<?php
function StampaDiv($testo, $classe)
{
	if (DEBUG)
		echo <<<EOT
			<div class="$classe">$testo</div>
EOT;
}
################################################################################
# AJAX-MESSAGE:
################################################################################
function ajax_message($codice, $messaggio) {
	echo "$codice|$messaggio";
	die();
}
################################################################################
# DEBUG:
################################################################################
function DEBUG($msg="", $newline=true) {
    error_log($msg);
    return;
    echo $msg;
    if ($newline)
        echo "<br />\n";
}
################################################################################
# MY VAR DUMP:
################################################################################
function my_var_dump($obj) {
	echo "<pre>";
    var_dump($obj);
    echo "</pre>";
}
################################################################################
# StampaErrore:
################################################################################
# Parametri:
#   $res - risultato dell'operazione che potrebbe aver generato l'errore.
#   $msg - messaggio da visualizzare in caso di errore.
#   $die - se dobbiamo 'morire' dopo la stampa del messaggio.
#   $debug - se il msg deve essere visualizzato SOLO se siamo in debug-mode.
################################################################################
function StampaErrore($res, $msg, $die=false, $debug_only=false) {
	if ($res != false)
		return;
	
	#if (($debug_only) && (!DEBUG))
	#	return;
		
	if (!$debug_only)
  {
    echo <<<EOT
    	<br>
    	<center>
      <div class='errore'>
      [ERROR]<br>
      <p>$msg</p>
      [/ERROR]
      </div>
      </center>
      <br>
EOT;
		if ($die)
			die();
  }
}

################################################################################
# Tabella:
################################################################################
# Parametri:
#   $nome_tabella - nome della tabella per la quale viene creato l'oggetto.
################################################################################
function Tabella($nome_tabella, $db) 
{
  if (strcmp($nome_tabella, "MetaProcedure") == 0) 
  	$t = new TabellaSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaProcedureParameter") == 0)
  	$t = new TabellaParametriSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaTableRefParameter") == 0) 
  	$t = new TabellaRiferimentoParametri($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaTableRefParameterValue") == 0) 
  	$t = new TabellaVoceRiferimento($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaUser") == 0) 
  	$t = new TabellaUtenti($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaGroup") == 0) 
  	$t = new TabellaGruppi($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaUserGroup") == 0)
  	$t = new TabellaAssociazioneUtentiGruppi($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaGroupProcedure") == 0) 
  	$t = new TabellaAssociazioneGruppiSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaProcedureBatch") == 0) 
  	$t = new TabellaPrenotazioni($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalLog") == 0) 
  	$t = new TabellaLog($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalNoDate") == 0) 
  	$t = new TabellaNoDate($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalAdvice") == 0) 
  	$t = new TabellaAvvisi($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaTable") == 0) 
  	$t = new TabellaTabelle($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaUserTable") == 0) 
  	$t = new TabellaAssociazioneUtentiTabelle($db, DEBUG);
	else if (strcmp($nome_tabella, "Qualifiche") == 0) 
  	$t = new TabellaQualifiche($db, DEBUG);
	else if (strcmp($nome_tabella, "Servizi") == 0) 
  	$t = new TabellaServizi($db, DEBUG);
	else
		StampaErrore(false, "Tabella '".$nome_tabella."' inesistente!", true);
  	
	return $t;
}

################################################################################
# StampaFormSQL:
################################################################################
# Parametri:
#   $strSQL - Stringa che inizializza la textarea.
################################################################################
function StampaFormSQL($strSQL) 
{
	echo <<<EOT
			<br>
      <form action="" method="POST" class="MioForm">
        <div class="header">SQL</div>
      	<div>
        	<textarea name="sql" cols="45" rows="8">$strSQL</textarea>
        </div>
				<div class="footer">
        	<button type="submit" name="Invia">Invia</button>
				</div>
      </form>
			<br>
EOT;
}

################################################################################
# Selected:
################################################################################
# Parametri:
#   $value1 - primo valore da comparare.
# 	$value2 - secondo valore da comparare.
################################################################################
function Selected($value1, $value2) 
{
	if (strcmp($value1, $value2) == 0)
		return " selected ";
  else
  	return "";
}

################################################################################
# CreaCSV:
################################################################################
# Parametri:
#   $filename - nome del file csv da creare.
################################################################################
function CreaCSV($filename) 
{
	$array_risultati = $_SESSION["recordset"];
	$totale_record = count($array_risultati);
	//$numfields = $recordset->FieldCount();
  $numfields = count($array_risultati[0]) / 1; // Sono doppi perch��un vettore indicizzato 
    																						 // per numero e per nome colonna.
    
  $fd = fopen($filename, "w");
  
  if ($fd == false)
  	return false;
  
  //----------------------------------------------------------------------------
  // Nomi dei campi:
  $nomi_colonne = array_keys($array_risultati[0]);
  fwrite($fd, $nomi_colonne[0]);
  for ($f = 1; $f < $numfields; $f++)
  {
  	fwrite($fd, CSV_FIELD_SEPARATOR);
    fwrite($fd, $nomi_colonne[$f]);
  }
    
  fwrite($fd, "\n");
  
  //----------------------------------------------------------------------------
  // Record:
  // Per ogni riga:
	for ($row=0; $row<$totale_record; $row++)
  {
  	// Per ogni colonna:
  	for ($i=0; $i < $numfields; $i++)
  	{
    	if ($i != 0)
    		fwrite($fd, CSV_FIELD_SEPARATOR);
			//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			$valore = trim($array_risultati[$row][$nomi_colonne[$i]]);
			if (my_is_numeric($valore)) {
				$valore = str_replace(".", ",", $valore);
			}
			//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			fwrite($fd, $valore);
    }
    fwrite($fd, "\n");
  }
  
  fclose($fd);
  return true;
}

################################################################################
# is_datetime:
################################################################################
# Parametri:
#   $parametro - parametro da controllare sia del formato data (gg/mm/aaaa).
################################################################################
function is_datetime($parametro) 
{
	if (strlen($parametro) > 10)
  	return false;
  // Delimitatori di testo: barre, punti, trattini
  list ($giorno, $mese, $anno) = split ('[/.-]', $parametro);
  return checkdate($mese, $giorno, $anno);
}

################################################################################
# print_html_header:
################################################################################
function print_html_header() 
{
	$titolo = TITOLO;
	$file_css = FILE_CSS;
	//<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	//<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	
	echo <<<EOT
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html>

<!-- HEAD -->
<head>
<title>$titolo</title>
<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-15'>
<link rel='stylesheet' type='text/css' href='css/style.css' />
</head>

<body>
EOT;
}

################################################################################
# print_month:
################################################################################
function print_month($m) {
	switch ($m) {
		case 0:
			$mese = "gennaio";
			break;
		case 1:
			$mese = "febbraio";
			break;
		case 2:
			$mese = "marzo";
			break;
		case 3:
			$mese = "aprile";
			break;
		case 4:
			$mese = "maggio";
			break;
		case 5:
			$mese = "giugno";
			break;
		case 6:
			$mese = "luglio";
			break;
		case 7:
			$mese = "agosto";
			break;
		case 8:
			$mese = "settembre";
			break;
		case 9:
			$mese = "ottobre";
			break;
		case 10:
			$mese = "novembre";
			break;
		case 11:
			$mese = "dicembre";
			break;
	}
	return $mese;
}

################################################################################
# print_week:
################################################################################
function print_week($w) {
	switch ($w) {
		case 0:
			$week = "Domenica";
			break;
		case 1:
			$week = "Luned&igrave;";
			break;
		case 2:
			$week = "Marted&igrave;";
			break;
		case 3:
			$week = "Mercoled&igrave;";
			break;
		case 4:
			$week = "Gioved&igrave;";
			break;
		case 5:
			$week = "Venerd&igrave;";
			break;
		case 6:
			$week = "Sabato";
			break;
	}
	return $week;
}

################################################################################
# print_date:
################################################################################
function print_date($timestamp, $ore=FALSE) {
	$day = getdate($timestamp);
	$week =  print_week($day["wday"]);
	
	$mese = print_month($day["mon"] - 1);
	echo $week.", ".$day["mday"]." ".$mese." ".$day["year"];
	if ($ore)
		printf(" - %d:%02d", $day["hours"], $day["minutes"]);
}

################################################################################
# my_htmlspecialchars:
################################################################################
function my_htmlspecialchars($stringa) 
{
  return 	str_replace(
  						array('"', "'", '<', '>', '�', '�', '�', '&igrave;', '�', '�'),
  						array ('&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						$stringa
  				);
}
################################################################################
# my_htmlspecialchars_decode:
################################################################################
function my_htmlspecialchars_decode($stringa) 
{
  return 	str_replace(
  						array ('&amp;', '&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						array('&', '"', "'", '<', '>', '�', '�', '�', '&igrave;', '�', '�'),
  						$stringa
  				);
}
################################################################################
# my_htmlspecialchars_decode2:
################################################################################
function my_htmlspecialchars_decode2($stringa) 
{
  return 	str_replace(
  						array ('&amp;', '&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						array('&', '"', "'", '<', '>', "a'", "e'", "e'", "i'", "o'", "u'"),
  						$stringa
  				);
}
################################################################################
# my_is_numeric:
################################################################################
function my_is_numeric($stringa_numerica) 
{
  return ereg("^[+-]?[0-9]*\.?[0-9]+$", trim($stringa_numerica));
}
################################################################################
# pgsql_data_encode:
################################################################################
function pgsql_date_encode($stringa) 
{
	if (strlen($stringa) == 0)
		return "";
	list($g,$m,$a) = split("[/.-]", $stringa);
	$data = array($a, $m, $g);
	return implode("-", $data);
}
################################################################################
# pgsql_data_decode:
################################################################################
function pgsql_date_decode($stringa) 
{
	if (strlen($stringa) == 0)
		return "";
	list($a,$m,$g) = split("[/.-]", $stringa);
	$data = array($g, $m, $a);
	return implode("/", $data);
}
################################################################################
# getVar:
################################################################################
function getVar($tipo, $nome, $default=null) {
	$res = $default;
	switch ($tipo) {
		case "POST":
			$res = (isset($_POST[$nome])) ? $_POST[$nome]: $default;
			break;
			
		case "GET":
			$res = (isset($_GET[$nome])) ? $_GET[$nome]: $default;
			break;
			
		case "SESSION":
			$res = (isset($_SESSION[$nome])) ? $_SESSION[$nome]: $default;
			break;
			
		default:
			$res = $default;
			break;
	}
	$res = str_replace("''", "'", $res);//Tolgo gli apici che il form introduce.
	$res = str_replace("\'", "'", $res);//Tolgo gli apici che il form introduce.
	#return my_htmlspecialchars(trim($res));
	return trim($res);
}

################################################################################
# assert_type:
################################################################################
function assert_type($tipo, $valore, $link, $opzionale=false) {	
	// Se il param �Opzionale e il suo valore �NULL:
	if ($opzionale)
		if (strlen($valore) == 0)
			return true;

	switch ($tipo) {
		// INTEGER -------------------------------------
		case "integer":
			if (!(strpos($valore, ".") === false));
			elseif (!(strpos($valore, ",") === false));
			elseif (is_numeric($valore))
				return true;
			break;
		// DECIMAL -------------------------------------
		case "decimal":
			if (is_numeric($valore))
				return true;
			break;
		// CHAR ----------------------------------------
		case "char":
			if (strlen($valore) == 1)
				if ((($valore >= 'A') && ($valore <= 'Z')) || 
						(($valore >= 'a') && ($valore <= 'z')) || 
						(($valore >= '0') && ($valore <= '9')))
					return true;
			break;
		// STRING --------------------------------------
		case "string":
			if (is_string($valore))
				return true;
			break;
		// DATETIME ------------------------------------
		case "datetime":
			if (is_datetime($valore))
				return true;
			break;
	}
	
	$titolo = "Errore";
	$descrizione = "Valore non corretto (".$valore.").";
	
	set_errore($titolo, $descrizione, $link);
}
################################################################################
# festivo:
################################################################################
function festivo($gg, $mm, $aaaa) {
	$t = getdate(mktime(0, 0, 0, $mm, $gg, $aaaa));
	if ($t["wday"] == 0)
		return TRUE;
	$gg = $t["mday"];
	$mm = $t["mon"];
	$aaaa = $t["year"];
	
	if ((($gg == 1) && ($mm == 1)) ||
			(($gg == 6) && ($mm == 1)) ||
			(($gg == 25) && ($mm == 4)) ||
			(($gg == 1) && ($mm == 5)) ||
			(($gg == 2) && ($mm == 6)) ||
			(($gg == 15) && ($mm == 8)) ||
			(($gg == 13) && ($mm == 10)) ||
			(($gg == 1) && ($mm == 11)) ||
			(($gg == 8) && ($mm == 12)) ||
			(($gg == 25) && ($mm == 12)) ||
			(($gg == 26) && ($mm == 12)) ||
			pasqua_gregoriana($gg-1, $mm, $aaaa)) // Pasquetta.
		return TRUE;
	return FALSE;
}
################################################################################
# giorni_settimana:
################################################################################
function giorni_settimana($num, $sub=0) {
	switch ($num) {
		case 0:
			$sett = "Domenica";
			break;
		case 1:
			$sett = "Lunedi";
			break;
		case 2:
			$sett = "Martedi";
			break;
		case 3:
			$sett = "Mercoledi";
			break;
		case 4:
			$sett = "Giovedi";
			break;
		case 5:
			$sett = "Venerdi";
			break;
		case 6:
			$sett = "Sabato";
			break;	
	}
	return ($sub) ? substr($sett, 0, $sub) : $sett;
}
################################################################################
# pasqua_gregoriana:
################################################################################
function pasqua_gregoriana($gg, $mm, $aaaa) {
	if (($mm != 3) && ($mm != 4)) {
		return FALSE;
	}
		
	$x = 24;
	$y = 5;
	
	$a = $aaaa % 19;
	$b = $aaaa % 4;
	$c = $aaaa % 7;
	$d = (19 * $a + $x) % 30;
	$e = (2 * $b + 4 * $c + 6 * $d + $y) % 7;
	
	$p = 22 + $d + $e;
	
	if ($p <= 31) {
		$gp = $p;
		$mp = 3;
	}
	elseif (($p - 31 != 25) && ($p - 31 != 26)) {
		$gp = $p - 31;
		$mp = 4;
	}
	elseif ($p - 31 == 26) {
		$gp = 19;
		$mp = 4;
	}
	elseif (($p - 31 == 25) && ($d == 28) && ($a > 10)) {
		$gp = 18;
		$mp = 4;
	}
	else {
		$gp = 25;
		$mp = 4;
	}
	if (($gp == $gg) && ($mp == $mm))
		return TRUE;
	
	return FALSE;
}
################################################################################
# getFloat:
################################################################################
function getFloat($string_number, $null=false) {
	if ((strlen($string_number) == 0) && ($null))
		return "";
		
	// cerco se NON ci sono PUNTI:
	if (strpos($string_number, ".") === FALSE) {
		// Sostituisco eventuali virgole con punti:
		return (float)str_replace(",", ".", $string_number);
	}
	// se invece CI SONO:
	else {
		// Se l'ultimo simbolo � un PUNTO:
		if (strrpos($string_number, ".") > strrpos($string_number, ",")) {
			// cancello le virgole:
			$string_number = str_replace(",", "", $string_number);
			return (my_is_numeric($string_number) == FALSE) ? (float)0 : (float)$string_number;
		}
		// se l'ultimo � una VIRGOLA:
		else {
			// cancello i punti:
			$string_number = str_replace(".", "", $string_number);
			// sostituisco la virgola con il punto:
			$string_number = str_replace(",", ".", $string_number);
			return (my_is_numeric($string_number) == FALSE) ? (float)0 : (float)$string_number;
		}
	}
}
################################################################################
# my_number_format:
################################################################################
function my_number_format($number, $decimals=-1, $dec_point=",", $thousands_sep=".") {
  $number = trim($number);
  if (!my_is_numeric($number))
  	return "0";
  if ($decimals == -1)
  	return str_replace(".", ",", $number);
  else
  	return number_format($number, $decimals, $dec_point, $thousands_sep);
}

################################################################################
# ShowMessage:
################################################################################
function ShowMessage($tipo, $title, $msg, $link=null, $caption=null, $link2=null, $caption2=null) {
	$_SESSION['msg_tipo'] = $tipo;
	$_SESSION['msg_link'] = $link;
	$_SESSION['msg_titolo'] = $title;
	$_SESSION['msg_descrizione'] = $msg;
	$_SESSION['msg_caption'] = $caption;
	$_SESSION['msg_link2'] = $link2;
	$_SESSION['msg_caption2'] = $caption2;
	
	header("Location: messaggio.php");
	die();
}
################################################################################
# quote_string:
################################################################################
# Parametro: stringa.
################################################################################
function quote_string($stringa, $null=false) {
	if ($null) {
		if (strlen($stringa) == 0)
			return "null";
		else
			return "'".str_replace(
  						array ('"', "'"),
  						array('"', "''"),
  						$stringa
  				)."'";
	}
	else
		return str_replace(
								array ('"', "'"),
								array('"', "''"),
								$stringa
						);
}
################################################################################
# null_if:
################################################################################
# Parametro: stringa.
################################################################################
function null_if($stringa) {
	if (strlen($stringa) == 0)
		return "null";
	return $stringa;
}
################################################################################
# toBool:
################################################################################
# Parametro: char (S/N).
################################################################################
function toBool($char) {
	if (strcasecmp($char, 'S') == 0)
		return true;
	return false;
}
################################################################################
# write_bool:
################################################################################
function write_bool($stringa) {
	if (strlen($stringa) == 0)
		return "null";
	elseif (($stringa == '1') || ($stringa == 'S') || $stringa)
		return "true";
		
	return "false";
}
################################################################################
# write_number:
################################################################################
function write_number($stringa, $null=false) {
	
	// La stringa e' VUOTA:
	if (strlen($stringa) == 0)
		return ($null) ? "null" : "";
	
	if (preg_match ("/\A(-){0, 1}([0-9]+)((,|.)[0-9]{3, 3})*((,|.)[0-9]){0, 1}([0-9]*)\z/" ,$stringa) == 1)
		return 0;
	
	// ____________________________________________________
	// La stringa NON ha PUNTI:
	if (strpos($stringa, ".") === false) {
		// e nemmeno VIRGOLE
		if (strpos($stringa, ",") === false) {
			return intval($stringa);
		}
		// c'e' almeno UNA virgola:
		else {
			// se ce n'e' piu' d'una:
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);
		}
	}
	// ____________________________________________________
	// La stringa NON ha VIRGOLE:
	else if (strpos($stringa, ",") === false) {
		// se c'e' piu' di un PUNTO:
		if (substr_count($stringa, ".") > 1)
			return 0;
		else
			return $stringa;
		
	}
	// ____________________________________________________
	// La stringa ha PUNTI e VIRGOLE:
	else {
		# se l'ultimo e' un PUNTO:
		if (strrpos($stringa, ".") > strrpos($stringa, ",")) {
			$stringa = str_replace(",", "", $stringa);
			if (substr_count($stringa, ".") > 1)
				return 0;
			else
				return $stringa;
		}
		# se l'ultimo e' una VIRGOLA:
		else {
			$stringa = str_replace(".", "", $stringa);
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);;
		}
	}
}
################################################################################
# date_diff:
################################################################################
if (!function_exists("date_diff")) {
function date_diff($d1, $d2){
    $d1 = (is_string($d1) ? strtotime($d1) : $d1);
    $d2 = (is_string($d2) ? strtotime($d2) : $d2);

    $diff_secs = abs($d1 - $d2);
    $base_year = min(date("Y", $d1), date("Y", $d2));

    $diff = mktime(0, 0, $diff_secs, 1, 1, $base_year);
    return array(
        "years" => date("Y", $diff) - $base_year,
        "months_total" => (date("Y", $diff) - $base_year) * 12 + date("n", $diff) - 1,
        "months" => date("n", $diff) - 1,
        "days_total" => floor($diff_secs / (3600 * 24)),
        "days" => round($diff_secs / (3600 * 24)), #date("j", $diff) - 1,
        "hours_total" => floor($diff_secs / 3600),
        "hours" => date("G", $diff),
        "minutes_total" => floor($diff_secs / 60),
        "minutes" => (int) date("i", $diff),
        "seconds_total" => $diff_secs,
        "seconds" => (int) date("s", $diff)
    );
}
}

################################################################################
# hex2rgb:
################################################################################
function hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   //return implode(",", $rgb); // returns the rgb values separated by commas
   return $rgb; // returns an array with the rgb values
}

################################################################################
# sum_time:
################################################################################
function sum_time() {
    $s = 0;
    foreach (func_get_args() as $time) {
        $time = trim($time);
        if (strlen($time) == 0)
            continue;
            
        sscanf($time, '%d:%d:%d', $hour, $min, $sec);
        $s += $hour * 3600 + $min * 60 + $sec;
    }
    if ($m = floor($s / 60)) {
        $s %= 60;
    }
    if ($h = floor($m / 60)) {
        $m %= 60;
    }
    return sprintf('%02d:%02d:%02d', $h, $m, $s);
}
?>
