// crea l'oggetto per la comunicazione AJAX con il server
// compatibile con tutti i browser che supportano AJAX
function crea_http_req() {
	var req = false;
	if (typeof XMLHttpRequest != "undefined")
		req = new XMLHttpRequest();
	if (!req && typeof ActiveXObject != "undefined") {
		try {
			req=new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e1) {
			try {
				req=new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e2) {
				try {
					req=new ActiveXObject("Msxml2.XMLHTTP.4.0");
				} catch (e3) {
					req=null;
				}
			}
		}
	}

	if(!req && window.createRequest)
		req = window.createRequest();

	if (!req) alert("Il browser non supporta AJAX");

	return req;
}

// l'oggetto per comunicare con il server
var http_req = null;


/*******************************************************************************
* Funzioni ASINCRONE
*******************************************************************************/
function ajax_send(page, params, target) {
	if (page.length == 0)
		return;

	http_req = crea_http_req();

	http_req.open('POST', page, true);
	http_req.onreadystatechange = function () {
	//---------------------------------------------------------------------------------
		if (http_req.readyState == 4) {
			target.innerHTML = http_req.responseText;
		}
	//---------------------------------------------------------------------------------
	};
	http_req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	http_req.setRequestHeader("Content-length", params.length);
	http_req.setRequestHeader("Connection", "close");
	http_req.send(params);
}

function ajax_submit(page, formname, target) {
	var elemento;
	var params = 'inizio=SI';
	var obj_form = document.getElementById(formname);

	if (obj_form == undefined) {
		obj_form = document.forms[formname];
	}
	if (obj_form == undefined) {
		alert('Impossibile associare l\'oggetto \'' + formname + '\'.');
		return;
	}

	for (i=0; i<obj_form.elements.length; i++) {
		elemento = obj_form.elements[i];
		params = params + '&' + elemento.name + '=' + elemento.value;
		//alert("The field name is: " + elemento.name + " and it's value is: " + elemento.value + ".<br>");
	}
	params = params + '&fine=SI';
	ajax_send(page, params, target);
}

/*******************************************************************************
* Funzioni SINCRONE
*******************************************************************************/
function sync_send(page, params, target) {
	if (page.length == 0)
		return;

	http_req = crea_http_req();

	http_req.open('POST', page, false);
	http_req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	//http_req.setRequestHeader("Content-length", params.length);
	//http_req.setRequestHeader("Connection", "close");
	http_req.send(params);


	if (target)
		target.innerHTML = http_req.responseText;
	else
		return http_req.responseText;
}

function sync_submit(page, formname, target) {
	var elemento;
	var params = 'inizio=SI';
	var obj_form = document.getElementById(formname);

	if (obj_form == undefined) {
		obj_form = document.forms[formname];
	}
	if (obj_form == undefined) {
		alert('Impossibile associare l\'oggetto \'' + formname + '\'.');
		return;
	}

	
	for (i=0; i<obj_form.elements.length; i++) {
		elemento = obj_form.elements[i];
		params = params + '&' + elemento.name + '=' + elemento.value;
		//alert("The field name is: " + elemento.name + " and it's value is: " + elemento.value + ".<br>");
	}
	params = params + '&fine=SI';
	
	if (target)
		sync_send(page, params, target);
	else
		return sync_send(page, params, null);
}