<?php
require_once("include/common.inc.php");

$titolo = getVar("POST", "titolo", null);
$code = getVar("POST", "code", null);
$padre = getVar("POST", "padre", null);
$relazione = getVar("POST", "relazione", null);
$classe = getVar("POST", "classe", null);
$ok = getVar("POST", "link_ok");
$fail = getVar("POST", "link_fail");
$indietro = getVar("POST", "link_indietro");
$elimina = getVar("POST", "elimina", 0);

$messaggio = new Messaggio();

###################################################################
# Memorizzo questi dati in sessione
###################################################################
if (strlen($classe) > 0) {
	unset($_SESSION["ULTIMO_OGGETTO"]);
	$_SESSION["ULTIMO_OGGETTO"]["titolo"] = $titolo;
	$_SESSION["ULTIMO_OGGETTO"]["code"] = $code;
	$_SESSION["ULTIMO_OGGETTO"]["code_padre"] = $padre;
	$_SESSION["ULTIMO_OGGETTO"]["relazione"] = $relazione;
	$_SESSION["ULTIMO_OGGETTO"]["classe"] = $classe;
	$_SESSION["ULTIMO_OGGETTO"]["link_ok"] = $ok;
	$_SESSION["ULTIMO_OGGETTO"]["link_fail"] = $fail;
	$_SESSION["ULTIMO_OGGETTO"]["link_indietro"] = $indietro;
	$pagina = $_SESSION["ULTIMO_OGGETTO"];
}
elseif (isset($_SESSION["ULTIMO_OGGETTO"])) 
	$pagina = $_SESSION["ULTIMO_OGGETTO"];

###################################################################
if (strlen($pagina["classe"]) == 0) {
	$messaggio->setTipo(MSG_ERROR);
	$messaggio->setTitolo("Gestione oggetto");
	$messaggio->setMessaggio("Classe non dichiarata. Impossibile continuare.");
	$messaggio->setLink(0, "Indietro", $fail);
	$messaggio->show();
}


###################################################################

$oggetto = Factory::crea($pagina["classe"], $pagina["code"]);

###################################################################
# ASSEGNAZIONI
###################################################################
#require_once("include/common_footer.inc");
$smarty->assign("oggetto", $oggetto);
$smarty->assign("pagina", $pagina);

if ($elimina == 1) {
	header("Location:elimina.php");
	exit();
}
$smarty->display('oggetto.tpl');
?>