<?php
require_once('include/common.inc.php');

$avanti = getVar("GET", "avanti", 0);
$indietro = getVar("GET", "indietro", 0);

$data_inizio = getVar("GET", "data");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_zero']))
    $data_inizio = $_SESSION['PLANNING_data_zero'];
else
    $data_inizio = date('Y-m-d');

$t = strtotime($data_inizio);
$arr_t = getdate($t);

$giorno_zero = 1; #intval($arr_t['mday']) + $avanti - $indietro;
$mese_zero = 2;#$arr_t['mon'];
$anno_zero = 2016;#$arr_t['year'];

$giorni_planning = 62;
$data_inizio = date('Y-m-d', mktime(0,0,0, $mese_zero, $giorno_zero, $anno_zero));
$data_fine = date('Y-m-d', mktime(0,0,0, $mese_zero, $giorno_zero + $giorni_planning, $anno_zero));
#sprintf("%d-%02d-%02d", $anno_zero, $mese_zero, $giorno_zero);
$data_fine = '2016-06-02';

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a')) + 1;

$_SESSION['PLANNING_data_zero'] = $data_inizio;

$obj_calendario = Calendario::getInstance();
$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();
#Calendario::save();
$calendario = $obj_calendario->getCalendario();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('P');
$obj_planning->setGiorni($giorni_planning);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
$obj_planning->setTipiTurnoGuardie($tipi_turno);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();
#Planning::save();

#-------------------------------------------------------------------------------
# MEDICI DISPONIBILI
#-------------------------------------------------------------------------------
$disponibili = array();
$indisponibili = array();
$inferie = array();
$incongresso = array();
$inriposo = array();
$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    #if ($giorno['festa'])
    #    continue;
    foreach($anagrafiche as $code => $anag) {
        
        if (!isset($turni[$code][$data])) {
            if ($giorno['festa'] == 0)
                $disponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["DISP"])) {
            if ($giorno['festa'] == 0)
                $disponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["I"])) {
            $indisponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["R"])) {
            $inriposo[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["F"])) {
            $inferie[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["C"])) {
            $incongresso[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        /*else {
            echo " NON e' disponibile";
            print_r($turni[$code][$data]);
        }
        echo "\r\n";*/
    }
}
# Memorizzo i disponibili per futuri usi:
$_SESSION["MEDICI_DISPONIBILI"] = $disponibili;

#-------------------------------------------------------------------------------
# ASSEGNAZIONI
#-------------------------------------------------------------------------------


    $smarty->assign("disponibili", $disponibili);
    $smarty->assign("indisponibili", $indisponibili);
    $smarty->assign("inferie", $inferie);
    $smarty->assign("incongresso", $incongresso);
    $smarty->assign("inriposo", $inriposo);


$smarty->assign("calendario", $calendario);
$smarty->assign("guardie", $obj_planning->getGuardie());
$smarty->assign("pianolavoro", $obj_planning->getPianoLavoro());
$smarty->assign("avvisi", $obj_planning->getAvvisi());
$smarty->assign("giorni", $giorni_planning);
$smarty->display('planning.tpl');
?>
