<?php
require("include/clsTCPDF.inc.php");

class iPDF extends PDF
{
	var $Title;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(5);
	}
	
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}

}
//***************************************************************
$cell_width = 6;

$pdf = new iPDF('P');
$pdf->Title = "PLANNING GUARDIE";
$pdf->SetMargins(15, 5);
$pdf->AddPage();

//-----------------------------------------------------------------------
// PAGINA
//-----------------------------------------------------------------------
$pdf->SetDrawColor(0, 0, 0);
$pdf->SetFillColor(255, 130, 99);
$pdf->SetLineWidth(0);
$pdf->SetFont('','B',12);
$pdf->SetTextColor(0, 0, 0);

/*$pdf->Cell(40, 5, "", 0, 0, 'C', 0);
$pdf->Cell(15, 5, "Cat.", 1, 0, 'C', 1);
$pdf->Cell(30, 5, "Tabellare", 1, 0, 'C', 1);
$pdf->Cell(25, 5, "Dipendenti", 1, 0, 'C', 1);  	
$pdf->Cell(20, 5, "%", 1, 0, 'C', 1);  	
$pdf->Cell(35, 5, "Dip. che passano", 1, 0, 'C', 1);  	
$pdf->Cell(35, 5, "% che passano", 1, 0, 'C', 1);  	
$pdf->Cell(30, 5, "Avanzo", 1, 1, 'C', 1);
*/
$fill = 0;
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(224,235,255);
$pdf->SetFont('','',8);

//-----------------------------------------------------------------------
// INTESTAZIONE PLANNING
//-----------------------------------------------------------------------
$first = true;
foreach($calendario as $key => $g) {
    if ($first || $g['giorno'] == 1) {
        $first = false;
        
        # Calendario
        $pdf->SetTextColorHex("#000");
        $pdf->SetFillColorHex("#FF0");
        $pdf->Cell(30, 4, "{$g['mese']} {$g['anno']}", 1, 0, 'C', 1);
        
        # Turni
        $pdf->SetTextColorHex("#FFF");
        $pdf->SetFillColorHex("#333");
        foreach($tipi_turno as $tipo_turno => $turno) {
            $pdf->Cell(30, 4, $turno, 1, 0, 'C', 1);
        }
        $pdf->Ln();
    }
    
    if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
    elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
    elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
    elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
    else {$bgcolor='#FFF'; $fcolor = '#000'; }
            
    $pdf->SetTextColorHex($fcolor);
    $pdf->SetFillColorHex($bgcolor);
        

    # Calendario
    $pdf->Cell(30, 4, "{$g['gsettimana']} {$g['giorno']}", 1, 0, 'C', 1);

    # Guardie
    foreach($tipi_turno as $tipo_turno => $turno) {
        if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
        elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
        elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
        elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
        else {$bgcolor='#DDD'; $fcolor = '#000'; }    
        $pdf->SetTextColorHex($fcolor);
        $pdf->SetFillColorHex($bgcolor);
    
        $code_anagrafica = $guardie[$g['data']][$tipo_turno]["code_anagrafica"];
        $color = $anagrafiche[$code_anagrafica]['colore'];
        $background = $anagrafiche[$code_anagrafica]['background'];
        
        $pdf->SetTextColorHex($color);
        $pdf->SetFillColorHex($background);
        $pdf->Cell(30, 4, $code_anagrafica, 1, 0, 'C', 1);
    }
    $pdf->Ln();
}
/*
{foreach name=cal item=g key=key from=$calendario}
        <tr>
            
            {foreach item="turno" key="tipo_turno" from=$tipi_turno}
                {assign var="code_anagrafica" value=$guardie[$g.data][$tipo_turno]["code_anagrafica"]|default:""}
                
                {if $g.festivita}{assign var="bgcolor" value='#ccd9ff'}
                {elseif $g.prefestivita}{assign var="bgcolor" value='#e5ecff'}
                {elseif $g.sabato}{assign var="bgcolor" value='#ffe5f2'}
                {elseif $g.domenica}{assign var="bgcolor" value='#ffcce6'}
                {else}{assign var="bgcolor" value='#DDD'}{/if}
                <td data="{$g.data}" tipo_turno="{$tipo_turno}" code_anagrafica="{$code_anagrafica}" class="guardie" style="{$border} color:{$anagrafiche[$code_anagrafica].colore|default:black};background:{$anagrafiche[$code_anagrafica].background|default:$bgcolor};">{$code_anagrafica}</td>
            {/foreach}
        </tr>
    {/foreach}
    */

/*
$pdf->Cell(30, 4, "", 0, 0, 'C', 0);
foreach($mesi as $mese) {
	$pdf->Cell($cell_width*$mese['giorni'], 4, $mese["nome"], 1, 0, 'C', $fill);
}
$pdf->Ln();
$pdf->Cell(30, 4, "", 0, 0, 'C', 0);
for ($i=0; $i<$GIORNI_PLANNING; $i++) {
	if ($intestazione[$i]["festivo"])
		$pdf->SetFillColor(255,0,0);
	else
		$pdf->SetFillColor(200,200,200);
	$pdf->Cell($cell_width, 4, $intestazione[$i]["sigla"], 1, 0, 'C', 1);
}
$pdf->Ln();
$pdf->Cell(30, 4, "", 0, 0, 'C', 0);
for ($i=0; $i<$GIORNI_PLANNING; $i++) {
	if ($intestazione[$i]["festivo"])
		$pdf->SetFillColor(255,0,0);
	else
		$pdf->SetFillColor(200,200,200);
	$pdf->Cell($cell_width, 4, $intestazione[$i]["giorno"], 1, 0, 'C', 1);
}
$pdf->Ln(7);

//-----------------------------------------------------------------------
// SISTEMAZIONI
//-----------------------------------------------------------------------
for ($c=0; $c<count($sistemazioni); $c++) {
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(5, 5, $sistemazioni[$c][0]["piano"], 1, 0, 'C', $fill);
	$pdf->Cell(7, 5, $sistemazioni[$c][0]["camera_numero"], 1, 0, 'C', $fill);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(8, 5, $sistemazioni[$c][0]["camera_tipo"], 1, 0, 'C', $fill);
	$pdf->Cell(8, 5, $sistemazioni[$c][0]["camera_bagno"], 1, 0, 'C', $fill);
	$pdf->Cell(2, 5, "", 0, 0, 'C', $fill);
	
	$pdf->SetFont('Arial','',6);
	for ($i=0; $i<2*$GIORNI_PLANNING; $i++) {
		#-----------------------------------------------
		# Imposto i colori
		switch($sistemazioni[$c][$i]["flag"]) {
			case 'P':
				if ($sistemazioni[$c][$i]["tipo"] == 'A')
					$pdf->SetFillColor(254,167,77);
				else
					$pdf->SetFillColor(255,218,138);
				break;
			case 'A':
				if ($sistemazioni[$c][$i]["tipo"] == 'A')
					$pdf->SetFillColor(133,142,196);
				else
					$pdf->SetFillColor(173,185,255);
				break;
			case 'O':
				if ($sistemazioni[$c][$i]["tipo"] == 'A')
					$pdf->SetFillColor(200,190,25);
				else
					$pdf->SetFillColor(255,248,107);
				break;
			case 'M':
				if ($sistemazioni[$c][$i]["tipo"] == 'A')
					$pdf->SetFillColor(100,100,100);
				else
					$pdf->SetFillColor(128,128,128);
				break;
			case 'K':
				if ($sistemazioni[$c][$i]["tipo"] == 'A')
					$pdf->SetFillColor(255,110,110);
				else
					$pdf->SetFillColor(255,140,140);
				break;
			default:
				$pdf->SetFillColor(255,255,255);
				break;
		}
		#-----------------------------------------------
		
		$pdf->Cell($cell_width/2, 5, $sistemazioni[$c][$i]["nominativo"], 1, 0, 'C', 1);
	}
	$pdf->Ln();
}
*/

$pdf->Output("planning-guardie.pdf", 'D');
?>
