<?php
require_once('include/common.inc.php');

$avanti = getVar("GET", "avanti", 0);
$indietro = getVar("GET", "indietro", 0);
$stampa = getVar("GET", "stampa", 0);

$data_inizio = getVar("GET", "inizio");
$data_fine = getVar("GET", "fine");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = '2016-06-01';

if (strlen($data_fine) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_fine']))
    $data_fine = $_SESSION['PLANNING_data_fine'];
else
    $data_fine = '2016-10-02';
    
$data_inizio = '2016-02-01';


$sql = "SELECT
        tipo_giornata, tipo_turno, t.code_anagrafica, count(*) as c
        FROM turni t
        left join tipo_turni_guardia ttg ON t.tipo_turno=ttg.code
        where data BETWEEN date '{$data_inizio}' AND date '{$data_fine}'
        and tipo_turno like 'CARDIO\_%'
        --and tipo_giornata='FERIALE'
        group by t.code_anagrafica, tipo_giornata, tipo_turno
        order by tipo_giornata, tipo_turno, count(*) desc, code_anagrafica;";
$sql = "SELECT
        c.tipo_giornata_guardie, tipo_turno, t.code_anagrafica, count(*) as c
        FROM turni t
        join calendario c ON c.data=t.data
        where t.data BETWEEN date '{$data_inizio}' AND date '{$data_fine}'
        and (tipo_turno like 'CARDIO\_%' OR tipo_turno IN ('F', 'C'))
        group by t.code_anagrafica, c.tipo_giornata_guardie, tipo_turno
        order by c.tipo_giornata_guardie, tipo_turno, count(*) desc, code_anagrafica;";
$rs = $db->Esegui($sql);
$data = $rs->GetArray();

$totalizzatore1 = array();
foreach ($data as $item) {
    $tipo_giornata = $item["tipo_giornata_guardie"];
    $tipo_turno = $item["tipo_turno"];
    $code_anagrafica = $item["code_anagrafica"];
    $totale = $item["c"];
    
    $totalizzatore1[$tipo_giornata][$tipo_turno][$code_anagrafica] = $totale;
}

require("include/clsTCPDF.inc.php");

class iPDF extends PDF
{
	var $Title;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(5);
	}
	
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}

}
//***************************************************************
$cell_width = 6;

$pdf = new iPDF('P');
$pdf->Title = "TOTALIZZATORI GUARDIE PER TIPO TURNO";
$pdf->SetMargins(15, 5);
$pdf->AddPage();

//-----------------------------------------------------------------------
// PAGINA
//-----------------------------------------------------------------------
$pdf->SetDrawColor(0, 0, 0);
$pdf->SetFillColor(255, 130, 99);
$pdf->SetLineWidth(0);
$pdf->SetFont('','B',12);
$pdf->SetTextColor(0, 0, 0);


$fill = 0;
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(224,235,255);
$pdf->SetFont('','',8);

//-----------------------------------------------------------------------
// INTESTAZIONE PLANNING
//-----------------------------------------------------------------------
$pdf->Cell(30, 4, "TIPO GIORNATA", 1, 0, 'C', 1);
$pdf->Cell(40, 4, "ANAGRAFICA", 1, 0, 'C', 1);
foreach ($tipi_turno as $tipo)
    $pdf->Cell(20, 4, $tipo, 1, 0, 'C', 1);
$pdf->Cell(10, 4, "F", 1, 0, 'C', 1);
$pdf->Cell(10, 4, "C", 1, 0, 'C', 1);
$pdf->Ln();

//-----------------------------------------------------------------------
// TOTALI
//-----------------------------------------------------------------------
$i=0;
$color = "#000";
# $totalizzatore1[$tipo_giornata][$tipo_turno][$code_anagrafica] = $totale;
foreach($totalizzatore1 as $tipo_giornata => $giornata) {
    
    foreach($guardiani as $anagrafica) {
        switch ($tipo_giornata) {
            case 'FERIALE':
                $background = ($i % 2) ? "#EEE" : "#FFF";
                break;
            case 'FESTIVO':
                $background = ($i % 2) ? "#FDD" : "#FEE";
                break;
            case 'FESTIVITA':
                $background = ($i % 2) ? "#DDF" : "#EEF";
                break;
        }
        $pdf->SetTextColorHex($color);
        $pdf->SetFillColorHex($background);


        $code_anagrafica = $anagrafica["code"];
        $nominativo = $code_anagrafica ." - ". $anagrafica["cognome"] ." ". $anagrafica["nome"];
        
        
        $pdf->Cell(30, 4, $tipo_giornata, 1, 0, 'C', 1);
        $pdf->Cell(40, 4, $nominativo, 1, 0, 'C', 1);
        foreach ($tipi_turno as $tipo_turno => $tipo) {
        
            if (isset($totalizzatore1[$tipo_giornata][$tipo_turno][$code_anagrafica]))
                $totale = $totalizzatore1[$tipo_giornata][$tipo_turno][$code_anagrafica];
            else
                $totale = 0;
                
            
            $pdf->Cell(20, 4, $totale, 1, 0, 'C', 1);
        }
        $pdf->Cell(10, 4, $totalizzatore1[$tipo_giornata]["F"][$code_anagrafica], 1, 0, 'C', 1);
        $pdf->Cell(10, 4, $totalizzatore1[$tipo_giornata]["C"][$code_anagrafica], 1, 0, 'C', 1);

        $pdf->Ln();
        $i++;
    }

}

$pdf->Output("totali-per-turno.pdf", 'D');
?>
