<!DOCTYPE HTML>
<html lang="it">
<head>
{include file="js-common.tpl"}



{literal}
<script language="JavaScript" type="text/javascript">
var dialog_ferie = false;

require(["dojo/on", "dojo/dom", "dijit/registry", "dijit/layout/BorderContainer", "dijit/layout/TabContainer", "dojox/layout/ContentPane", "dijit/Dialog", "dijit/form/DateTextBox", "dojo/domReady!"],
function(on, dom, registry, BorderContainer, TabContainer, ContentPane, Dialog, DateTextBox){
    console.debug("Progetta onReady - Start");
    // *********************************************************************
    // CONTAINER
    // *********************************************************************
    var progettaLayout = new BorderContainer({
        design: "headline"
    }, "progettaLayout");


    // *********************************************************************
    // HEADER
    progettaLayout.addChild(
        new ContentPane({
            region: "top",
            style: "border: 0px;"
        }, "progettaToolbar")
    );
    // FATTURA
    progettaLayout.addChild(
        new ContentPane({
            region: "center"
        }, "progettaBody")
    );
    
    MostraGuardieProgetta();
    console.debug("Progetta onReady - End");
});

function ReloadProgetta(url=null) {
    var cp = dijit.byId("progettaBody");
    if (url)
        cp.set('href', url);
    else {
        //cp.refresh();
        var i = dojo.date.locale.format(dijit.byId('filtro_data_inizio').value, { datePattern: "yyyy-MM-dd", selector: "date"} );
        var f = dojo.date.locale.format(dijit.byId('filtro_data_fine').value, { datePattern: "yyyy-MM-dd", selector: "date"} );
        url = "progetta_guardie.php?inizio=" + i + "&fine=" + f;
        cp.set('href', url);
        //alert(url);
    }
}
function MostraGuardieProgetta() {
    ReloadProgetta("progetta_guardie.php");
}
function MostraTurniProgetta() {
    ReloadProgetta("turni.php");
}
function GeneraTurniProgetta() {
    require(["dojo/request"], 
    function(request) {
        request("gestione_turni_cardiologia.php").then(
            function(text){
                console.log('Turni rigenerati ('+text+')');
                ReloadProgetta();
            },
            function(error){
                console.log("An error occurred: " + error);
            }
        );
    });
}
function AzzeraProgetta() {
    require(["dojo/request"], 
    function(request) {
        request("azzera_turni.php").then(
            function(text){
                console.log('Turni azzerati');
                ReloadProgetta();
            },
            function(error){
                console.log("An error occurred: " + error);
            }
        );
    });
}
function RigeneraTurniProgetta() {
    require(["dojo/request"], 
    function(request) {
        request("azzera_turni.php").then(
            function(text){
                GeneraTurniProgetta();
            },
            function(error){
                console.log("An error occurred: " + error);
            }
        );
    });
    
}


function StampaGuardieProgetta() {
    require(["dojo/request"], 
    function(request) {
        request("progetta_guardie.php?stampa=1").then(
            function(text){
                console.debug('Generata stampa');
            },
            function(error){
                console.log("An error occurred: " + error);
            }
        );
    });
    
}
/***********************************************************************************************
 * DIALOG FERIE
 **********************************************************************************************/
function DialogFerie(id) {
    require(["dojox/widget/DialogSimple"],
    function (DialogSimple) {
        
        if (dialog_ferie) {
            console.log("Dialog ferie esiste.");
            dialog_ferie.set("href", "upload-ferie.php?id=" + id);
        }
        else {
            console.log("Dialog ferie non esiste.");
            dialog_ferie = new DialogSimple({
                title: "Ferie",
                style: "width: 650px",
                executeScripts:true, 
                href: "upload-ferie.php?id="+id
            });
        }
        dialog_ferie.show();
    });
}
</script>
{/literal}
</head>

<body>

<div id="progettaLayout" style="border:0px;"></div>
<div id="progettaToolbar">
    <button data-dojo-type="dijit.form.Button" id="reload_progetta" onclick="ReloadProgetta();">Ricarica</button>
    <input type="text" id="filtro_data_inizio" name="filtro_data_inizio" value="{$data_inizio}" size="10" data-dojo-type="dijit/form/DateTextBox" />
    <input type="text" id="filtro_data_fine" name="filtro_data_fine" value="{$data_fine}" size="10" data-dojo-type="dijit/form/DateTextBox" />
    
    <button data-dojo-type="dijit.form.Button" id="guardie_progetta" onclick="MostraGuardieProgetta();">Guardie e piano di lavoro</button>
    <button data-dojo-type="dijit.form.Button" id="turni_progetta" onclick="MostraTurniProgetta();">Turni</button>
    
    <div style="float:right">
        {**}<button data-dojo-type="dijit.form.Button" id="azzera_progetta" onclick="AzzeraProgetta();">Azzera</button>
        <button data-dojo-type="dijit.form.Button" id="rigenera_turni_progetta" onclick="GeneraTurniProgetta();">Genera turni</button>
    </div>
    
    <!--button data-dojo-type="dijit.form.Button" id="ferie_progetta" onclick="DialogFerie();">Ferie</button-->
    <br>
    <button data-dojo-type="dijit.form.Button">
        Stampa guardie
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "progetta_guardie.php?stampa=1";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa piano di lavoro
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "progetta_guardie.php?stampa=2";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa piano di lavoro + emo
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "progetta_guardie.php?stampa=4";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa piano di lavoro completo
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "progetta_guardie.php?stampa=3";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa piano di lavoro completo + emo
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "progetta_guardie.php?stampa=5";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa turni
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "turni.php?stampa=1";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa turni + EMO
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "turni.php?stampa=2";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Stampa ferie
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "turni.php?stampa=3";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Totalizzatore 1
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "stampa_totali1.php";
        </script>
    </button>
    <button data-dojo-type="dijit.form.Button">
        Totalizzatore 2
        <script type="dojo/method" data-dojo-event="onClick" >
            window.location = "stampa_totali1-2.php";
        </script>
    </button>
</div>

<div id="progettaBody"></div>

</body>
</html>
