<?php
require_once('include/common.inc.php');

$avanti = getVar("GET", "avanti", 0);
$indietro = getVar("GET", "indietro", 0);
$stampa = getVar("GET", "stampa", 0);

$data_inizio = getVar("GET", "inizio");
$data_fine = getVar("GET", "fine");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = '2016-06-01';

if (strlen($data_fine) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_fine']))
    $data_fine = $_SESSION['PLANNING_data_fine'];
else
    $data_fine = '2016-10-02';
    
$stato = 'B';

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a')) + 1;

$obj_calendario = Calendario::getInstance();
$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();
#Calendario::save();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato($stato);
$obj_planning->setGiorni($giorni_planning);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
$obj_planning->setTipiTurnoGuardie($tipi_turno);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();



# CALCOLO TOTALI
$ore_settimana = array();
$ore_mese = array();
$date_start = $obj_calendario->getData($data_inizio, -40);
$date_end = $data_fine;

/*$sql = "SELECT 
        t.code_anagrafica,
        date_part('week', data) as woy, date_part('isoyear', data) as yow, 
        sum(ttg.ore) as ore_guardia, sum(d.ore) as ore_piano
        FROM turni t
        left join tipo_turni_guardia ttg ON t.tipo_turno=ttg.code
        left join destinazioni d ON t.tipo_turno=d.code
        where data BETWEEN date '{$date_start}' AND date '{$date_end}' AND (stato='{$stato}' OR stato='P')
        group by t.code_anagrafica, date_part('week', data), date_part('isoyear', data)
        order by yow, woy, code_anagrafica";*/
        
$sql = "SELECT 
        t.code_anagrafica,
        date_part('week', data) as woy, date_part('isoyear', data) as yow, 
        sum(ore) as ore
        FROM turni t
        where data BETWEEN date '{$date_start}' AND date '{$date_end}' AND (stato='{$stato}' OR stato='P')
        group by t.code_anagrafica, date_part('week', data), date_part('isoyear', data)
        order by yow, woy, code_anagrafica";
$rs = $db->Esegui($sql);

while (!$rs->EOF) {
    $woy = $rs->Fields("woy");
    $yow = $rs->Fields("yow");
    $code_anagrafica = $rs->Fields("code_anagrafica");
    $ore = $rs->Fields("ore");
    
    $ore_settimana[$yow][$woy][$code_anagrafica] = $ore;
    /*
    if (isset($pools[$pool]))
        $pools[$pool]++;
    else
        $pools[$pool] = 1;
    
    $anagrafiche[$code] = $rs->FetchRow();*/
    $rs->MoveNext();
}




foreach ($ore_settimana as $key1 => $item1) {
    foreach ($item1 as $key2 => $item2) {
        foreach ($item2 as $key3 => $item3) {
            #$ore = 0;
            $ore = '00:00:00';
            #echo "{$key1}, {$key2}------------------------------------------------------------------------------------------------<br>";

            for ($i=0; $i<4; $i++) {
                $yow = $key1;
                $woy = $key2 - $i;
                if ($woy <= 0) {
                    $yow--;
                    if (isset($ore_settimana[$yow][53][$code_anagrafica]))
                        $woy += 53;
                    else
                        $woy += 52;
                }
                $code_anagrafica = $key3;
                DEBUG("$yow $woy $code_anagrafica");
                #$ore += $ore_settimana[$yow][$woy][$code_anagrafica];
                #echo "{$ore} + {$ore_settimana[$yow][$woy][$code_anagrafica]} = ";
                $ore = sum_time($ore, $ore_settimana[$yow][$woy][$code_anagrafica]);
                #echo $ore."<br>";
            }
            $ore_mese[$key1][$key2][$key3] = $ore;
        }
    }
}
#$turni = $obj_planning->getTurni();
#print_r($ore_mese);
#exit();

#-------------------------------------------------------------------------------
# ASSEGNAZIONI
#-------------------------------------------------------------------------------
$calendario = $obj_calendario->getCalendario();
$turni = $obj_planning->getTurni();

if ($stampa == 0) {
    $smarty->assign("calendario", $calendario);
    $smarty->assign("turni", $turni);
    $smarty->assign("giorni", $giorni_planning);
    $smarty->assign("ore_settimana", $ore_settimana);
    $smarty->assign("ore_mese", $ore_mese);
    $smarty->display('turni.tpl');
}
elseif ($stampa == 1) {
    $EMO = false;
    require_once("stampa_turni.php");
}
elseif ($stampa == 2) {
    $EMO = true;
    require_once("stampa_turni2.php");
}
elseif ($stampa == 3) {
    require_once("stampa_ferie_utente.php");
}
?>
