<?php
/*
 * Classe che simula un calendario.
 */
class Calendario {
    private $calendario;
    private $data_inizio;
    private $data_fine;
    private $giorni;
    private $init;

    #*****************************************************************************
    # Parte STATICA
    #*****************************************************************************
    private static $instance = null;
    protected static $session_name = "OBJ-CALENDAR";

    #------------------------------------------
    public static function getInstance() {
        if (self::$instance == null) {
            if (isset($_SESSION[self::$session_name]))
                self::$instance = unserialize($_SESSION[self::$session_name]);
            else {
                $c = __CLASS__;
                self::$instance = new $c;
            }
        }
        return self::$instance;
    }

    #------------------------------------------
    public static function save() {
        $_SESSION[self::$session_name] = serialize(self::$instance);
    }

    #------------------------------------------
    public static function erase() {
        if (isset($_SESSION[self::$session_name])) {
                self::$instance = null;
                unset($_SESSION[self::$session_name]);
                #self::getInstance();
        }
    }
    #*****************************************************************************
    # Parte DINAMICA
    #*****************************************************************************
    private function __construct() {
        $this->calendario = array();
        $this->giorni = 0;
        $this->init = false;
    }

    #-----------------------------------------------------------------------------
    # INIT
    #-----------------------------------------------------------------------------
    public function init() {
        $t = strtotime($this->data_inizio);
        $arr_t = getdate($t);
        $giorno_zero = intval($arr_t['mday']);
        $mese_zero = $arr_t['mon'];
        $anno_zero = $arr_t['year'];
        
        for ($i=0; $i<$this->giorni; $i++) {
            $t = mktime(0, 0, 0, $mese_zero, $giorno_zero + $i, $anno_zero);
            $data = date("Y-m-d", $t);
            switch (date("w", $t)) {
                case 0:
                    $g = "Dom";
                    break;

                case 1:
                    $g = "Lun";
                    break;

                case 2:
                    $g = "Mar";
                    break;

                case 3:
                    $g = "Mer";
                    break;

                case 4:
                    $g = "Gio";
                    break;

                case 5:
                    $g = "Ven";
                    break;

                case 6:
                    $g = "Sab";
                    break;
            }
            switch (date("n", $t)) {
                case 1:
                    $ms = "Gen";
                    break;
                case 2:
                    $ms = "Feb";
                    break;
                case 3:
                    $ms = "Mar";
                    break;
                case 4:
                    $ms = "Apr";
                    break;
                case 5:
                    $ms = "Mag";
                    break;
                case 6:
                    $ms = "Giu";
                    break;
                case 7:
                    $ms = "Lug";
                    break;
                case 8:
                    $ms = "Ago";
                    break;
                case 9:
                    $ms = "Set";
                    break;
                case 10:
                    $ms = "Ott";
                    break;
                case 11:
                    $ms = "Nov";
                    break;
                case 12:
                    $ms = "Dic";
                    break;
            }
            #$g = substr($g, 0, 1);
            
            #DEBUG("*** Analizzo ".$data);
            $this->calendario[$data]["giorno"] = date("d", $t); 
            $this->calendario[$data]["gsettimana"] = $g; 
            $this->calendario[$data]["data"] = date("Y-m-d", $t); #date("d/m", $t);
            $this->calendario[$data]["anno"] = date("Y", $t);
            $this->calendario[$data]["woy"] = intval(date("W", $t));
            $this->calendario[$data]["yow"] = date("o", $t);
            $this->calendario[$data]["mese"] = $ms;
            #DEBUG("    sabato? ".$data);
            $this->calendario[$data]["sabato"] = $this->sabato($data);
            #DEBUG("    domenica? ".$data);
            $this->calendario[$data]["domenica"] = $this->domenica($data);
            #DEBUG("    festivita? ".$data);
            $this->calendario[$data]["festivita"] = $this->festivita($data);
            #DEBUG("    prefestivita? ".$data);
            $this->calendario[$data]["prefestivita"] = $this->prefestivita($data);
            #DEBUG("    festa? ".$data);
            $this->calendario[$data]["festa"] = $this->festa($data);
            #DEBUG("    fine analisi ".$data);
        }
    }
    
    #-----------------------------------------------------------------------------
    # GET
    #-----------------------------------------------------------------------------
	
    public function getCalendario() {
        return $this->calendario;
    }
    public function getData($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        $newdate = date("Y-m-d", $t);
        
        if ($offset_days > 0 && $data == $newdate) {
            error_log("!!!!!!!!!!!!!!!!!!!!!!! ATTENZIONE !!!!!!!!!!!!!!!!!!!!! $offset_days, $data, $newdate (tentativo #1)");
            $t += $offset_days*24*3600;
            $newdate = date("Y-m-d", $t);
        }
        if ($offset_days > 0 && $data == $newdate) {
            error_log("!!!!!!!!!!!!!!!!!!!!!!! ATTENZIONE !!!!!!!!!!!!!!!!!!!!! $offset_days, $data, $newdate (tentativo #2)");
            $t += $offset_days*24*3600;
            $newdate = date("Y-m-d", $t);
        }
        return $newdate;
    }
    public function sabato($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        if (date('w', $t) == 6) {
            return 1;
        }
        return 0;
    }
    public function domenica($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        if (date('w', $t) == 0) {
            return 1;
        }
        return 0;
    }
    public function lunedi($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        if (date('w', $t) == 1) {
            return 1;
        }
        return 0;
    }
    public function giovedi($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        if (date('w', $t) == 4) {
            return 1;
        }
        return 0;
    }
    public function venerdi($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        if (date('w', $t) == 5) {
            return 1;
        }
        return 0;
    }
    public function festa($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        $newdate = date("Y-m-d", $t);
        
        if (isset($this->calendario[$newdate])) {
            if ($this->calendario[$newdate]["sabato"] || 
                $this->calendario[$newdate]["domenica"] || 
                $this->calendario[$newdate]["prefestivita"] || 
                $this->calendario[$newdate]["festivita"])
                return 1;
        }
        
        if ($this->sabato($newdate) || $this->domenica($newdate) || $this->prefestivita($newdate) || $this->festivita($newdate))
            return 1;
        return 0;
    }
    public function festivita($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        $newdate = date("Y-m-d", $t);
        $festivita = 0;
        
        if (isset($this->calendario[$newdate]["festivita"])) {
            return $this->calendario[$newdate]["festivita"];
        }
        #DEBUG("Festivita': ".$newdate." (".$data.", ".$offset_days.")");
        
        # FESTIVITA'
        if (date("m-d", $t) == '01-01') { # Capodanno
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '01-06') { # Epifania
            $festivita = 1;
        }
        elseif (date("Y-m-d", $t) == date("Y-m-d", easter_date(date("Y", $t)))) { # Pasqua
            $festivita = 1;
        }
        elseif (date("Y-m-d", $t) == date("Y-m-d", easter_date(date("Y", $t)) + 24*3600)) { # Pasquetta
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '04-25') { # Liberazione
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '05-01') { # 1 maggio
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '06-02') { # Repubblica
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '06-24') { # Patrono di Genova
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '08-15') { # Ferragosto
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '11-01') { # Santi
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '12-08') { # Immacolata
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '12-25') { # Natale
            $festivita = 1;
        }
        elseif (date("m-d", $t) == '12-26') { # Santo Stefano
            $festivita = 1;
        }
        if ($festivita) {
            return 1;
        }
        
        # diventano giorni di festività anche eventuali fine settimana attaccati.
        # Se oggi è DOMENICA, guardo venerdi, lunedi e martedi attaccati:
        if ($this->domenica($newdate)) {
            #DEBUG('domenica');
            $venerdi = $this->getData($newdate, -2);
            $sabato = $this->getData($newdate, -1);
            $lunedi = $this->getData($newdate, +1);
            $martedi = $this->getData($newdate, +2);
            if ($this->festivita($venerdi)) {
                #DEBUG("venerdi si => domenica si");
                return 1;
            }
            #-------------------------------------------------------------------
            if ($this->festivita($sabato)) {
                #DEBUG("sabato si => domenica si");
                return 1;
            }
            #-------------------------------------------------------------------
            if ($this->festivita($lunedi)) {
                #DEBUG("lunedi si => domenica si");
                return 1;
            }
            #-------------------------------------------------------------------
            if ($this->festivita($martedi)) {
                #DEBUG("martedi si => domenica si");
                return 1;
            }
        }   
        # Se oggi è SABATO, guardo venerdi e lunedi:
        /*if ($this->sabato($newdate)) {
            #DEBUG('sabato');
            $venerdi = $this->getData($newdate, -1);
            if ($this->festivita($venerdi)) {
                #DEBUG("venerdi si => sabato si");
                return 1;
            }
            #-------------------------------------------------------------------
            # Se le feste sono nella settimana successiva, il sabato è pre-festività
            #$lunedi = $this->getData($newdate, +2);
            #if ($this->festivita($lunedi)) {
            #    DEBUG("lunedi si => sabato no");
            #    return 0;
            #}
        }
        # Se oggi è LUNEDI, guardo martedi (guardare domenica crea un loop infinito e non serve a niente!):
        if ($this->lunedi($newdate)) {
            #DEBUG('lunedi');
            $martedi = $this->getData($newdate, +1);
            if ($this->festivita($martedi)) {
                #DEBUG("martedi si => lunedi si");
                return 1;
            }
        } */
        return 0;
    }
    public function prefestivita($data, $offset_days=0) {
        $t = strtotime($data);
        $t += $offset_days*24*3600;
        $newdate = date("Y-m-d", $t);
        if (isset($this->calendario[$newdate]["prefestivita"])) {
            return $this->calendario[$newdate]["prefestivita"];
        }
        #DEBUG("PRE-Festivita': ".$newdate);
        # se tale giorno è festivo, non è prefestivo!
        if ($this->festivita($newdate, $offset_days))
            return 0;
        if ($this->giovedi($newdate, $offset_days))
            return 0;
        #DEBUG("PRE-Festivita': ".$newdate." non e' festa. Provo il giorno dopo:");
        return $this->festivita($newdate, $offset_days+1);
    }
    
    #-----------------------------------------------------------------------------
    # SET
    #-----------------------------------------------------------------------------
    
    public function setGiorni($giorni) {
        $this->giorni = $giorni;
    }
    public function setDataInizio($data) {
        $this->data_inizio = $data;
    }
    public function setDataFine($data) {
        $this->data_fine = $data;
    }
}
?>
