<?php

set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB');
require_once("classes/utente.class.php");
require_once("classes/medoo.class.php");

// require_once('Smarty/Smarty.class.php');
// require_once("Smarty/sysplugins/smarty_internal_compilebase.php");
// require_once("Smarty/sysplugins/smarty_internal_resource_string.php");
// require_once("Smarty/sysplugins/smarty_internal_templateparser.php");
// require_once("Smarty/sysplugins/smarty_internal_templatecompilerbase.php");
// require_once("Smarty/sysplugins/smarty_internal_compile_block.php");
// require_once("Smarty/sysplugins/smarty_internal_write_file.php");
// require_once("Smarty/sysplugins/smarty_internal_templatelexer.php");

class Session {
    public $smarty;
    private $vars;
    function __construct() {
        $this->vars = [];
    }
    
    public function get($varname) {
        if (isset($this->vars[$varname]))
            return $this->vars[$varname];
        elseif (isset($_SESSION[$varname]))
            return $_SESSION[$varname];
        return false;
    }
    
    public function set($varname, $value, $sess=false, $smart=false) {
        $this->vars[$varname] = $value;
        if ($sess)
            $_SESSION[$varname] = $value;
        if ($smart) {
            if (!isset($this->smarty))
                $this->smarty();
            $this->smarty->assign($varname, $value);
        }
    }
    
    public function user() {
        if (isset($_SESSION['USER']))
            $user = unserialize($_SESSION['USER']);
        else
            $user = new Utente();
        return $user;
    }
    
    public function smarty() {
        if (isset($this->smarty))
            return $this->smarty;
            
        $this->smarty = new \Smarty;
        $this->smarty->template_dir = "templates";
        $this->smarty->compile_dir = "templates_c";
        $this->smarty->cache_dir = "cache";
        $this->smarty->config_dir = "configs";
        $this->smarty->force_compile = true;

        $this->smarty -> left_delimiter = "{";
        $this->smarty -> right_delimiter = "}";
        
        #$this->smarty->assign("SERVER", NODE_SERVER);
        #$this->smarty->assign("PORT", NODE_PORT);
        #$this->smarty->assign("MOUNT", NODE_MOUNT);
        $this->smarty->assign("BASE_URL", BASE_URL);
        $this->smarty->assign("REQUEST_URI", $_SERVER["REQUEST_URI"]);
        $this->smarty->assign("URL_STATIC", "/static");
        $this->smarty->assign("TEST", TEST);


        return $this->smarty;
    }
    
    public function log($text) {
        if (is_object($text))
            error_log(var_export($text, true));
        elseif (is_array($text))
            error_log(var_export($text, true));
        else
            error_log($text);
    }
    
    public function checkLogin() {
        if (isset($_SESSION['USER']))
            return true;
        return false;
    }
    
    public function assertLogin($url=null) {
        if (!$this->checkLogin()) {
            if ($url)
                $this->set("REDIRECT_URL_AFTER_LOGIN", $url, true);
            header("Location:/login");
            exit();
        }
    }
    
    
}
?>