<?php
namespace phoenix;

set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB');
require_once("classes/result.class.php");

class PhoenixException extends \Exception { }
class EmailInvalidException extends \Exception { }
class EmailExistsException extends \Exception { }
class EmailEmptyPasswordException extends \Exception { }


class User extends Meta {
    private $_anagrafica;
    
    function __construct() {
        //parent::__construct();
        $this->_anagrafica = new Anagrafica();
        #error_log("Creato USER");
    }
    
    // public function __sleep() {
        // return array('_anagrafica');
    // }
    public function serialize() {
        
        return serialize([
            'anagrafica' => serialize($this->_anagrafica),
            'metadata' => parent::serialize()
        ]);
    }
    public function unserialize($data) {
        $data = unserialize($data);
        $this->_anagrafica = unserialize($data['anagrafica']);
        parent::unserialize($data['metadata']);
    }
    
    #
    #
    #
    public function anagrafica() {
        return $this->_anagrafica;
    }
    public function username() {
        return $this->get("username");
    }
    public function email() {
        return $this->get("email");
    }
    
    public function anagraficaCompleta() {
        return $this->_anagrafica->isCompleta();
    }
    
    public function stores() {
        $_SESSION['USER'] = serialize($this);
        return true;
    }
    
    public function load($username) {
        $db = getDB();
        
        $params = [];
        $params["username"] = strtolower($username);
        #error_log(var_export($params, true));
        $rows = $db->select("utenti", "*", $params);
        #error_log(var_export($rows, true));
        if ($rows === false)
            throw new PhoenixException("Utente inesistente.");
        if (count($rows) == 1) {
            $this->_fields = $rows[0];
            #$_SESSION['USER'] = serialize($this);
            $this->anagrafica()->carica($this);
            return true;
        }
            
        return false;
    }
    
    public function login($username, $password) {
        $db = getDB();
        
        $params = [];
        $params["username"] = strtolower($username);
        $params["secret"] = $password;
        $params["attivo"] = 'S';
        #error_log(var_export($params, true));
        $rows = $db->select("utenti", "*", $params);
        #error_log(var_export($rows, true));
        if ($rows === false)
            throw new PhoenixException("Errore nella verifica dell'email. Contattare l'assistenza.");
        if (count($rows) == 1) {
            if ($rows[0]["bannato"] == 'S')
                throw new PhoenixException("L'Utente &egrave; sospeso. Contattare l'assistenza.");
                
            $this->_fields = $rows[0];
            #$_SESSION['USER'] = serialize($this);
            $this->anagrafica()->carica($this);
            $this->stores();
            return true;
        }
            
        return false;
    }
    
    public function registrati($username, $password, $params=null) {
        GLOBAL $session;
        
        $db = getDB();
        $username = trim($username);
        $password = trim($password);
        
        if (!$this->esisteUtente($username, $db)) {
            if (strlen($password) == 0)
                throw new EmailEmptyPasswordException("La password non pu&ograve; essere vuota!");
                
            $p = [
                "username" => strtolower($username),
                "email" => strtolower($username),
                "secret" => $password,
                "attivo" => "N"
            ];
            foreach($params as $key => $value) {
                $p[$key] = $value;
            }
            
            #
            # Qui capiamo se il codice promo  un PROMO o il REFERRAL di un utente
            #
            $p2 = [];
            $p2["codice"] = $p["codice_promo"];
            $rows = $db->select("promo", "*", $p2);
            if (count($rows) == 0) {
                # non  un codice PROMO ma un REFERRAL
                $p["codice_invito"] = $p["codice_promo"];
                # prendo il codice promo dell'utente che l'ha invitato
                $p3 = [];
                $p3["codice"] = $p["codice_promo"];
                $rows3 = $db->select("nodi", "*", $p3);
                if (count($rows3) > 0)
                    $p["codice_promo"] = $rows3[0]["promo"];
            }
            else {
                #  un codice PROMO (non faccio niente)
                ;
            }
            
            #
            # Qui finalmente salviamo e creiamo l'utente.
            #
            $db->insert("utenti", $p);
            
            list($error_code, $error_number, $error_text) = $db->error();
            if ($db->id() > 0) {
                $ret = $db->id();
            }
            elseif ($error_code == '00000') {
                $ret = true;
            }
            else
                $ret = false;
            return $ret;
        }
        return false;
    }
    
    
    
    public function esisteUtente($username) {
        $db = getDB();
        $username = trim($username);
        
        if (!filter_var($username, FILTER_VALIDATE_EMAIL)) {
            throw new EmailInvalidException("Email non valida!");
        }
        
        $params = [];
        $params["username"] = strtolower($username);
        $rows = $db->select("utenti", "id", $params);
    
        
        if ($rows === false)
            throw new PhoenixException("Errore nella verifica dell'email. Contattare l'assistenza.");
        if (count($rows) > 0)
            throw new EmailExistsException("Email esistente!");
        return false;
    }
    
    public function esiste($username) {
        $db = getDB();
        $username = trim($username);
        
        if (!filter_var($username, FILTER_VALIDATE_EMAIL)) {
            throw new EmailInvalidException("Email non valida!");
        }
        
        $params = [];
        $params["username"] = strtolower($username);
        $rows = $db->select("utenti", "id", $params);
    
        
        if ($rows === false)
            throw new PhoenixException("Errore nella verifica dell'email. Contattare l'assistenza.");
        if (count($rows) > 0)
            return true;
        return false;
    }
    
    public function cambiaPassword($username=null, $password=null, $codice_verifica=null) {
        $db = getDB();
        $params = [];
        $where = [];
        
        # Se l'utente  loggato:
        if ($this->id() > 0) {
            $params["secret"] = $password;
            $where["username"] = strtolower($this->username());
        }
        # se non  loggato:
        else {
            if (strlen($codice_verifica) == 0)
                return false;
            
            if (strlen($username) > 0) {
                $params["codice_verifica"] = strtolower($codice_verifica);
                if (strlen($password))
                    $params["secret"] = $password;
                $where["username"] = strtolower($username);
            }
            elseif (strlen($password) > 0) {
                $params["codice_verifica"] = null;
                $params["secret"] = $password;
                $where["codice_verifica"] = strtolower($codice_verifica);
            }
            else
                return false;
        }
        
        $rows = $db->update("utenti", $params, $where);
        return $rows;
    }
    
    public function verificaUtente($code) {
        $db = getDB();
        $params = [];
        $params["codice_verifica"] = strtolower($code);
        $rows = $db->select("utenti", "id", $params);
    
        
        if ($rows === false)
            throw new PhoenixException("Errore nella verifica dell'email. Contattare l'assistenza.");
        if (count($rows) == 0)
            throw new EmailExistsException("Codice di verifica inesistente o non pi&ugrave; valido!");
        else {
            $rows = $db->update("utenti", ["attivo" => 'S'], $params);
            if ($rows->rowCount() == 1)
                return true;
        }
        return false;
    }
    
    public function salvaAnagrafica($params) {
        $db = getDB();
        $res = $this->_anagrafica->salva($this, $params);
        
        if ($res) {
            $this->_anagrafica->carica($this);
            
            $p = [ 
                'anagrafica_id' => $this->_anagrafica->id(),
                'codice' => strtoupper(substr(md5(microtime(true)), rand(1,8), 5)),
                'promo' => $this->get("codice_promo"),
                'referral' => $this->get("codice_referral")
            ];
            $db->insert("nodi", $p);
        }
        $this->stores();
        return $res;
    }

    public function notify($action, $params) {
        
        #------------------------------------------------------------------------------
        # REGISTRAZIONE
        #------------------------------------------------------------------------------
        if ($action == "REGISTRAZIONE") {
            #
            # INVIO EMAIL CONFERMA
            #
            $subject = "Abilitazione account Phoenix Project"; 
            $arrayto = array($this->username());
            
            $regurl = BASE_URL."registrati/verifica/{$params["codice_verifica"]}";

            $body_text = "Grazie per esserti registrato!\n\r
Per confermare la tua registrazione clicca sul link sotto:\n\r
\n\r
{$regurl}";
            $body_html =<<<EOT
<h3 style="color:#000;">Grazie per esserti registrato!</h3>
<p>Per confermare la tua registrazione clicca sul link sotto:</p>

<p><a href="{$regurl}">Conferma iscrizione a Phoenix Project</a>.</p>
EOT;

            request_send_mail($subject, $arrayto, $body_text, $body_html);
                
            $db = getDB();
                
            #
            # NOTIFICA TUTOR
            #
            $codice_tutor = $this->get("codice_invito");
            $tutor = "";
            if (strlen($codice_tutor) > 0) {
            
                $sql = "select u.email
                        from nodi n
                        join anagrafiche a ON a.id=n.anagrafica_id
                        join utenti u ON u.id=a.utente_id
                        where n.codice='{$codice_tutor}'";
                $rows = $db->query($sql)->fetchAll();
                if (count($rows))
                    $tutor = $rows[0]["email"];
                if (strlen($tutor)) {
                    $mess = "Un utente si e' iscritto e ti ha nominato suo Tutor.";
                    request_send_mail($subject, array($tutor), $mess, $mess);
                }
            }

            #
            # NOTIFICA PROMO
            #          
            $codice_promo = $this->get("codice_promo");  
            $promoter = "";
            if (strlen($codice_promo) > 0) {
            
                $sql = "select u.email
                        from promo n
                        join anagrafiche a ON a.id=n.anagrafica_id
                        join utenti u ON u.id=a.utente_id
                        where n.codice='{$codice_promo}'";
                $rows = $db->query($sql)->fetchAll();
                if (count($rows))
                    $promoter = $rows[0]["email"];
                if (strlen($promoter)) {
                    $mess = "Un utente si e' iscritto ad un tuo Tutor.";
                    request_send_mail($subject, array($promoter), $mess, $mess);
                }
            }
        } 
    }
}
?>