<?php
require_once('tcpdf/config/lang/ita.php');
require_once('tcpdf/tcpdf.php');

#---------------------------------------------------------------------------
# FUNCTIONS
#---------------------------------------------------------------------------
function update_session_user($user_token) {
    $user_token = slugify($user_token);
    #error_log("COOKIE: USER_TOKEN = ".$user_token);
    
    #$_SESSION['USER']['token'] = $user_token;
    #$_SESSION['USER']['login'] = 1;
}

# FUNZIONE SLUGIFY
function slugify($text) {
    // replace non letter or digits by -
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);

    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    // trim
    $text = trim($text, '-');

    // remove duplicate -
    $text = preg_replace('~-+~', '-', $text);

    // lowercase
    $text = strtolower($text);

    if (empty($text)) {
        return 'n-a';
    }

    return $text;
}

/*******************************************************************************
   
*******************************************************************************/
function check_login() {
    if (!isset($_SESSION['USER'])) {
        error_log("NON LOGGATO!!!!");
        header("Location:/login");
        exit();
    }
}

/*******************************************************************************
   UPLOAD GENERICO
*******************************************************************************/
function upload_file($nome_campo, $path_base, $path_rel, $base_name="", $ext_enable=array('PDF', 'PNG', 'JPG', 'JPEG', 'DOC', 'DOCX')) {
    $errore = false;
    $ret = array();
    
    if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
        $originale = basename($_FILES[$nome_campo]['tmp_name']);
        $path_parts = pathinfo($_FILES[$nome_campo]['name']);
        $extension = strtoupper($path_parts['extension']);

        if (!in_array($extension, $ext_enable)) {
            $errore = true;
            #show_message(MSGERROR, "Formato file non permesso!", false);
            #throw new Exception("Formato file non permesso!");
        }

        if (strlen($originale)) {
            $tipo = $_FILES[$nome_campo]['type'];
            $slug_name = slugify(basename($_FILES[$nome_campo]['name'], ".".strtolower($extension)));
            $name = $base_name.substr(md5($originale), 0, 8)."__".$slug_name.".".strtolower($extension);
            $res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
            if (!$res) {
                $errore = true;
                #show_message(MSGERROR, "Upload file {$nome_campo} fallito! (1)", false);
            }
        }
        $ret["name"] = $name;
        $ret["extension"] = $extension;
    }
    elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
        $errore = true;
        #show_message(MSGERROR, "Upload file {$nome_campo} fallito! (2)", false);
    }
    # else non c'e' niente da uploadare...
    else {
        #DEBUG("else non c'e' niente da uploadare...");
        return false;
    }
    if ($errore) {
        #DEBUG("errore");
        return false;
    }
    return $ret;
}

# VerifyPaypalIPN
function VerifyPaypalIPN(array $IPN = null){
    if(empty($IPN)){
        $IPN = $_POST;
    }
    if(empty($IPN['verify_sign'])){
        return null;
    }
    $IPN['cmd'] = '_notify-validate';
    $PaypalHost = (empty($IPN['test_ipn']) ? 'www' : 'www.sandbox').'.paypal.com';
    $cURL = curl_init();
    curl_setopt($cURL, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($cURL, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($cURL, CURLOPT_URL, "https://{$PaypalHost}/cgi-bin/webscr");
    curl_setopt($cURL, CURLOPT_ENCODING, 'gzip');
    curl_setopt($cURL, CURLOPT_BINARYTRANSFER, true);
    curl_setopt($cURL, CURLOPT_POST, true); // POST back
    curl_setopt($cURL, CURLOPT_POSTFIELDS, $IPN); // the $IPN
    curl_setopt($cURL, CURLOPT_HEADER, false);
    curl_setopt($cURL, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($cURL, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
    curl_setopt($cURL, CURLOPT_FORBID_REUSE, true);
    curl_setopt($cURL, CURLOPT_FRESH_CONNECT, true);
    curl_setopt($cURL, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($cURL, CURLOPT_TIMEOUT, 60);
    curl_setopt($cURL, CURLINFO_HEADER_OUT, true);
    curl_setopt($cURL, CURLOPT_HTTPHEADER, array(
        'Connection: close',
        'Expect: ',
    ));
    $Response = $text_response = curl_exec($cURL);
    $Status = (int)curl_getinfo($cURL, CURLINFO_HTTP_CODE);
    curl_close($cURL);
    if(empty($Response) or !preg_match('~^(VERIFIED|INVALID)$~i', $Response = trim($Response)) or !$Status){
        return array('UNDEFINED', $text_response);
    }
    if(intval($Status / 100) != 2){
        return array('STATUSKO', $text_response);
    }
    $verified = !strcasecmp($Response, 'VERIFIED');
    if ($verified)
        return array('VERIFIED', $text_response);
    else
        return array('INVALID', $text_response);
}

#VerifyPaypalPDT
function VerifyPaypalPDT($tx){
    $PDT['cmd'] = '_notify-synch';
    $PDT['tx'] = $tx;
    $PDT['ta'] = PAYPAL_ID_TOKEN;
    
    $PaypalHost = PAYPAL_SERVER;
    
    // Init cURL
    $request = curl_init();

    // Set request options
    curl_setopt_array($request, array
    (
      CURLOPT_URL => $PaypalHost,
      CURLOPT_POST => TRUE,
      CURLOPT_POSTFIELDS => http_build_query($PDT),
      CURLOPT_RETURNTRANSFER => TRUE,
      CURLOPT_HEADER => FALSE,
      CURLOPT_SSL_VERIFYPEER => FALSE,
      CURLOPT_SSL_VERIFYHOST => FALSE,
      // CURLOPT_CAINFO => 'cacert.pem',
    ));

    // Execute request and get response and status code
    $response = curl_exec($request);
    $status   = curl_getinfo($request, CURLINFO_HTTP_CODE);

    // Close connection
    curl_close($request);
    
    error_log(var_export($response, true));
    
    if ($status == 200 AND strpos($response, 'SUCCESS') === 0) {
        // Further processing

        // Remove SUCCESS part (7 characters long)
        $response = substr($response, 7);

        // URL decode
        $response = urldecode($response);

        // Turn into associative array
        preg_match_all('/^([^=\s]++)=(.*+)/m', $response, $m, PREG_PATTERN_ORDER);
        $response = array_combine($m[1], $m[2]);
        
        return $response;
    }
    else {
        // Log the error, ignore it, whatever
        
    }
    
    return false;
}
# PUBLISH
function publish($channel, $message, $ext) {
    $data = array("channel" => $channel, "data" => $message, "ext" => $ext);  
    $data_string = json_encode($data);
    
    $ch = curl_init(NODE_SERVER.":".NODE_PORT."/".NODE_MOUNT);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type:application/json','Content-Length:'.strlen($data_string)));
    $result = curl_exec($ch);
    return $result;
}

# SEND AS JSON
function echo_json($text, $clear_buffer=true) {
    # cancella il buffer (cancella eventuali 'echo' precedenti che non dovrebbero esserci)
    if ($clear_buffer)
        ob_clean();
    echo json_encode($text);
}

# TOR CHECK FUNCTION
function IsTorExitPoint(){
    if (gethostbyname(ReverseIPOctets($_SERVER['REMOTE_ADDR']).".".$_SERVER['SERVER_PORT'].".".ReverseIPOctets($_SERVER['SERVER_ADDR']).".ip-port.exitlist.torproject.org")=="127.0.0.2") {
        return true;
    } else {
        return false;
    } 
}
function ReverseIPOctets($inputip){
    $ipoc = explode(".",$inputip);
    return $ipoc[3].".".$ipoc[2].".".$ipoc[1].".".$ipoc[0];
}

function get($name, $default=null, $source_array=null) {
    $value = null;
    
    if (!is_null($source_array)) {
        if (isset($source_array[$name]))
            $value = $source_array[$name];
    }
    elseif (isset($_GET[$name])) {
        $value = $_GET[$name];
    }
    elseif (isset($_POST[$name])) {
        $value = $_POST[$name];
    }
    elseif (isset($_SESSION[$name])) {
        $value = $_SESSION[$name];
    }

    if (is_null($value) && !is_null($default))
        return $default;

    return $value;
}

# GENERA CODICE PORTA UN AMICO
function genera_codice_porta_un_amico() {
    return strtoupper(substr(md5(microtime()), rand(0, 10), 5));
}

# FUNZIONE REAL-SENDMAIL
function real_send_mail($subject, $arrayto, $body_text, $body_html=null, $from=null, $replyto=null) {
    require_once 'mailer/swift_init.php';
    require_once 'mailer/swift_required.php';
    
    #error_log("-------------------------------------------------------------");
    #error_log($from);
    #error_log(var_export($arrayto, true));
    #error_log("-------------------------------------------------------------");
    
    if (!is_array($arrayto))
        $arrayto = array($arrayto);

    //$https['ssl']['cafile'] = '/etc/ssl/netshopisp.cer';
    
    // Create the Transport
    $transport = Swift_SmtpTransport::newInstance('ermes.aspide.net', 587, 'tls')
        ->setUsername("support@phoenixproject.social")
        ->setPassword('Cheope-2566')
        #->setStreamOptions($https)
    ;
    /*$transport = Swift_SmtpTransport::newInstance('smtp.gmail.com', 465, 'ssl')
        ->setUsername('')
        ->setPassword('')
    ;*/
    
    // Create the Mailer using your created Transport
    $mailer = Swift_Mailer::newInstance($transport);
    
    if (is_null($from) || strlen(trim($from)) == 0)
        $from = array("support@phoenixproject.social" => 'Support Team Phoenix');
    
    if (is_array($replyto))
        error_log($replyto[0]);
    elseif (is_null($replyto))
        $replyto = array("support@phoenixproject.social" => 'Support Team Phoenix');  
        
    if (TEST) {
        $arrayto = array("marcello@aspide.net" => 'Notify Phoenix');
        $body_text = "TEST\r\n".$body_text;
        $body_html = "<h1>TEST</h1>".$body_html;
    }
        
    // Create the message
    $message = Swift_Message::newInstance()

        // Give the message a subject
        ->setSubject($subject)
        
        ->setReplyTo($replyto)

        // Set the From address with an associative array
        ->setFrom($from)

        // Set the To addresses with an associative array
        ->setTo($arrayto)

        // Set the Bcc addresses with an associative array
        ->setBcc(array("marcello@aspide.net" => 'Notify Phoenix', "support@phoenixproject.social" => 'Support Phoenix'))
        
        // Give it a body
        ->setBody($body_text)

        // And optionally an alternative body
        ->addPart($body_html, 'text/html')

        // Optionally add any attachments
        //->attach(Swift_Attachment::fromPath('my-document.pdf'))
    ;

    // Send the message
    $result = $mailer->send($message, $failures);
    return $failures;
}

# REQUEST_SEND_MAIL
function request_send_mail($subject, $arrayto, $body_text, $body_html=null, $from=null, $replyto=null) {
    return real_send_mail($subject, $arrayto, $body_text, $body_html, $from, $replyto);
    exit();
    #FIRMA MARIOBID
    #$contents = file_get_contents("../mbid/static/images/logo2.png");
    #$base64   = base64_encode($contents); 
    #$embed_img = 'data:' . 'image/png;base64,' . $base64;
    #$embed_img = WEBSITE_URL."static/images/logo2.png";
    
    #$body_html .= "<br><br><img alt='MARIOBID' src='{$embed_img}' />";
    #$body_text .= "\r\n\r\nMARIOBID";


    $message = array();
    $message['subject'] = $subject;
    $message['arrayto'] = $arrayto; #http_build_query($arrayto);
    $message['body_text'] = $body_text;
    $message['body_html'] = $body_html;
    $message['from'] = $from;
    $ext = array('password' => SECRET);
    
    
    
    return publish("/mail", $message, $ext);
    /*$data = array("channel" => "/mail", "data" => $message, "ext" => $ext);  
    $data_string = json_encode($data);
    
    $ch = curl_init(NODE_SERVER);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type:application/json','Content-Length:'.strlen($data_string)));
    $result = curl_exec($ch);
    return $result;*/
}

# GET DB
function getDBxxx() {
    $params = [
        // required
        'database_type' => "pgsql", #DB_TYPE,
        'database_name' => DBNAME,
        'server' => DBHOST,
        'username' => DBUSER,
        'password' => DBPSWD,
     
        // [optional]
        'charset' => 'utf8',
        #'port' => 3306,
     
        // [optional] Table prefix
        #'prefix' => 'PREFIX_',
     
        // [optional] Enable logging (Logging is disabled by default for better performance)
        'logging' => true,
     
        // [optional] MySQL socket (shouldn't be used with server and port)
        #'socket' => '/tmp/mysql.sock',
     
        // [optional] driver_option for connection, read more from http://www.php.net/manual/en/pdo.setattribute.php
        #'option' => [
        #	PDO::ATTR_CASE => PDO::CASE_NATURAL
        #],
     
        // [optional] Medoo will execute those commands after connected to the database for initialization
        #'command' => [
        #	'SET SQL_MODE=ANSI_QUOTES'
        #]
    ];
    $db = new Medoo\Medoo($params);
    return $db;
}

function getDB() {
    /*******************************************************************************
       CONNESSIONE AL DATABASE
    *******************************************************************************/
    if (isset($_SESSION["DB"])) {
        #DEBUG("DB esiste gia'!");
        $db = unserialize($_SESSION["DB"]);
    }
    else {
        $db = new DB(DBTYPE);
        
        if (isset($_SESSION["dbname"]) && isset($_SESSION["dbuser"]) && isset($_SESSION["dbpasswd"])) {
            #DEBUG("Mi collego su ".$_SESSION["dbname"]);
            $res = $db->Connetti(DBHOST, $_SESSION["dbuser"], $_SESSION["dbpasswd"], $_SESSION["dbname"]) or die('connessione fallita');
            if ($res) {
                $_SESSION["DB"] = serialize($db);
            }
        }
        else {
            #DEBUG("Mi collego su default.");
            $res = $db->Connetti(DBHOST, DBUSER, DBPSWD, DBNAME) or die('connessione fallita');
            
            if ($res) $_SESSION["DB"] = serialize($db);
        }
        if ($res) 
            $db->Init();
        #if (is_object($db))
            $_SESSION["DB"] = serialize($db);
        #else
        #    exit('DB not is object!');
        
        #print_r($_SESSION);
        #exit();
    }
    return $db;
}

# GET USER
function getUser() {
    GLOBAL $user;
    
    if (isset($user))
        ;
    elseif (isset($_SESSION['USER']))
        $user = unserialize($_SESSION['USER']);
    else
        $user = new phoenix\User();
    return $user;
}

# GET CATEGORIE
function getCategories($cat=false) {
    GLOBAL $CATEGORIE;
    
    if ($cat === false)
        return $CATEGORIE;
        
    foreach($CATEGORIE as $item) {
        if ($item["codice"] == $cat)
            return $item;
    }
    return false;
}

# number
function to_number($stringa, $format_from='it', $format_to='us') {
	
	// La stringa e' VUOTA:
	if (strlen($stringa) == 0)
		return "";
	
	if (preg_match ("/\A(-){0, 1}([0-9]+)((,|.)[0-9]{3, 3})*((,|.)[0-9]){0, 1}([0-9]*)\z/" ,$stringa) == 1)
		return 0;
        
    # TODO: distinguere formati di ingresso/uscita.
    # Al momento converte qualunque cosa in formato 'us'.

	// ____________________________________________________
	// La stringa NON ha PUNTI:
	if (strpos($stringa, ".") === false) {
		// e nemmeno VIRGOLE
		if (strpos($stringa, ",") === false) {
			return intval($stringa);
		}
		// c'e' almeno UNA virgola:
		else {
			// se ce n'e' piu' d'una:
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);
		}
	}
	// ____________________________________________________
	// La stringa NON ha VIRGOLE:
	else if (strpos($stringa, ",") === false) {
		// se c'e' piu' di un PUNTO:
		if (substr_count($stringa, ".") > 1)
			return 0;
		else
			return $stringa;
		
	}
	// ____________________________________________________
	// La stringa ha PUNTI e VIRGOLE:
	else {
		# se l'ultimo e' un PUNTO:
		if (strrpos($stringa, ".") > strrpos($stringa, ",")) {
			$stringa = str_replace(",", "", $stringa);
			if (substr_count($stringa, ".") > 1)
				return 0;
			else
				return $stringa;
		}
		# se l'ultimo e' una VIRGOLA:
		else {
			$stringa = str_replace(".", "", $stringa);
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);;
		}
	}
}

#---------------------------------------------------------------------------
# Donazione pagata
#---------------------------------------------------------------------------
# Il pagamento  stato effettuato con successo e bisogna fare le cose.
#---------------------------------------------------------------------------
function donazione_pagata($transazione_id, $metodo_pagamento=1) {
    GLOBAL $session;
    
    $tipo_dteam = $session->get("tipo_dteam");
    $codice_sogno_target = $session->get("codice_sogno");
    $codice_sogno_pagante = false;
    $rinnovo = $session->get("rinnovo");
    $manager = new phoenix\ManagerNodi();
    
    # Donazione LIBERA
    if ($tipo_dteam == 0) {
        $importo = $session->get("importo_donazione");
        $res = $manager->dona_libera($codice_sogno_target, $importo, $transazione_id, $metodo_pagamento);
    }
    # Rinnovo D-TEAM
    elseif ($rinnovo == 'S') {
        $session->log("donazione_pagata::rinnovo");
        $codice_sogno_pagante = $session->get("codice_sogno_pagante");
        $codice_sogno_target = $session->get("codice_sogno_target");
        $session->log("RINNOVO {$tipo_dteam}: {$codice_sogno_pagante} -> {$codice_sogno_target}");
        
        # aggiorniamo le relazioni
        $res = $manager->rinnova_dteam($codice_sogno_pagante, $codice_sogno_target, $tipo_dteam, $transazione_id, $metodo_pagamento);
    }
    # Donazione D-TEAM
    else {
        #
        # TODO
        # Qui devo vedere se esiste gi una relazione tra un mio sogno e il sogno target. se c' il pagante  quello
        # altrimenti prendo a caso il primo tra i miei sogni che non sono iscritti ad un dteam.
        #
        
        $user = $session->user(); #getUser();
        $codici_sogno = $user->anagrafica()->sogni();
        foreach($codici_sogno as $key => $item) {
            $nodo = new phoenix\Nodo();
            $nodo->carica($item["codice"]);
            if ($nodo->padre($tipo_dteam) === false) {
                $codice_sogno_pagante = $item["codice"];
            }
        }
        $session->log("Sogno target: {$codice_sogno_target}, dteam: {$tipo_dteam}, Sogno pagante: {$codice_sogno_pagante}");
        if ($codice_sogno_pagante === false) {
            return false;
        }
        
        # aggiorniamo le relazioni
        $res = $manager->dona_dteam($codice_sogno_pagante, $codice_sogno_target, $tipo_dteam, $transazione_id, $metodo_pagamento);
    }
    return $res;
}





class PDF extends TCPDF {
	function Header() {
			$this->AliasNbPages();
			//Arial bold 15
			$this->SetFont('','B',15);
			/*if ($this->CurOrientation == 'L')
				$this->Image('images/logo_webx.png', (297-52)/2, 5, 52, 12);
			else
				$this->Image('images/logo_webx.png', (210-52)/2, 5, 52, 12);
			*/
			//Colors of frame, background and text
			$this->SetDrawColor(0,80,180);
			$this->SetFillColor(230,230,0);
			$this->SetTextColor(220,50,50);
			//Title
			//$this->Cell($w,9,"WEB X",1,1,'C',1);
			//Line break
			$this->Ln(15);
	}
	
	function Footer() {
			/*//Position at 1.5 cm from bottom
			$this->SetY(-15);
			//Arial italic 8
			$this->SetFont('','I',8);
			//Text color in gray
			$this->SetTextColor(128);
			//Page number
			$this->Cell(0,10,'Pag. '.$this->PageNo()."/{nb}",0,0,'C');*/
	}
}
################################################################################
# hex2rgb:
################################################################################
function hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   //return implode(",", $rgb); // returns the rgb values separated by commas
   return $rgb; // returns an array with the rgb values
}
class iPDF extends PDF {
    var $Title;
    var $margin_left;
    var $margin_right;
    var $margin_top;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(5);
	}

    function SetMargins($left, $top, $right=0) {
        if ($right == 0)
            $right = $left;

        $this->margin_left = $left;
        $this->margin_right = $right;
        $this->margin_top = $top;
        PDF::SetMargins($left, $top, $right, true);
    }
    
    
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}
}

function stampaFattura($fattura_id) {
    GLOBAL $session;

    $user = $session->user();
    $db = getDB();
        
    $sql = "SELECT *, to_char(data, 'DD/MM/YYYY') as data_fattura FROM fatture
            WHERE anagrafica_id={$user->anagrafica()->id()} AND id={$fattura_id}";
    error_log($sql);
    try {
        $rows = $db->query($sql)->fetchAll();
    }
    catch(Exception $ex) {
        error_log($ex->getMessage());
        error_log( var_export($db->error(), true) );
    }
    $row = $rows[0];
    $fattura = [
        "intestatario" => [
            "ragione_sociale" => $row["cognome"]." ".$row["nome"],
            "indirizzo" => $row["indirizzo"],
            "comune" => $row["comune"],
            "nazione" => $row["nazione"],
            "cf" => $row["cf"]
        ],
        "anno" => $row["anno"],
        "numero" => $row["numero"],
        "data" => $row["data_fattura"],
        "descrizione" => "Oneri e prestazioni relativi alle donazioni ricevute.",
        "imponibile" => $row["importo_servizio_ie"],
        "banca" => $row["importo_banca"],
        "iva" => [
            "22" => $row["importo_servizio_iva"]
        ],
        "totale" => $row["importo_servizio_ie"] + $row["importo_banca"] + $row["importo_servizio_iva"]
    ];
    
    //***************************************************************
    $pdf = new iPDF('P');
    $pdf->AliasNbPages();
    $pdf->Title = "";
    $pdf->AddPage();

    //-----------------------------------------------------------------------
    // PAGINA
    //-----------------------------------------------------------------------
    $pdf->SetDrawColor(185, 185, 185);
	$pdf->SetFillColor(255, 157, 16);
    $pdf->SetTextColor(85, 85, 85);
    $pdf->SetFont('','B',10);

    /************************************************************************
    * COPIA COMMERCIALISTA
    ************************************************************************/
    $LEFT_OFFSET = 25;
    $pdf->SetXY($LEFT_OFFSET + 100, 70);

    //-----------------------------------------------------------------------
    // CLIENTE
    //-----------------------------------------------------------------------
    $pdf->SetLeftMargin($LEFT_OFFSET + 80);
    $pdf->Ln(1);
    $pdf->SetFont('','B', 8);
    $pdf->Cell(80, 5, "Utente", 1, 1, 'L', 1);
    $pdf->SetFont('','', 10);
    $pdf->MultiCell(80, 4, $fattura["intestatario"]["ragione_sociale"], 'LR', 'L', 0);
    $pdf->Cell(80, 4, $fattura["intestatario"]["indirizzo"], 'LR', 1, 'L', 0);
    $pdf->Cell(80, 4, $fattura["intestatario"]["comune"]." - ".$fattura["intestatario"]["nazione"], 'LR', 1, 'L', 0);
    $pdf->Cell(80, 4, "C.F.: ".$fattura["intestatario"]["cf"], 'LRB', 1, 'L', 0);

    //-----------------------------------------------------------------------
    // NUMERO e DATA FATTURA
    //-----------------------------------------------------------------------
    $pdf->SetLeftMargin($LEFT_OFFSET);
    $pdf->Ln(10);

    $pdf->SetFont('','B', 8);
    #$pdf->Cell(50, 5, "", 0, 1, 'L', 0);

    $pdf->Cell(30, 5, "Numero fattura", 1, 0, 'L', 1);
    $pdf->SetFont('','', 8);
    $pdf->Cell(30, 5, $fattura["numero"]."/".$fattura["anno"], 1, 1, 'L', 0);

    $pdf->SetFont('','B', 8);
    $pdf->Cell(30, 5, "Data documento", 1, 0, 'L', 1);
    $pdf->SetFont('','', 8);
    $pdf->Cell(30, 5, $fattura["data"], 1, 1, 'L', 0);

    if (strlen($fattura["descrizione"])) {
        $pdf->SetFont('','B', 8);
        $pdf->Cell(30, 5, "Descrizione", 1, 0, 'L', 1);
        $pdf->SetFont('','', 8);
        $pdf->MultiCell(130, 5, $fattura["descrizione"], 1, 'L', 0);
    }
    $pdf->Ln(10);

    
    //-----------------------------------------------------------------------
    // TOTALI
    //-----------------------------------------------------------------------
    $pdf->SetMargins($LEFT_OFFSET+80, 1);
    $pdf->Ln(1);
    $pdf->SetFont('','B', 8);
    $pdf->Cell(40, 5, "TOTALE", 1, 0, 'C', 1);
    $pdf->Cell(40, 5, "Importi", 1, 1, 'C', 1);
    $pdf->SetFont('','', 8);
    $pdf->Cell(40, 5, "Imponibile", 1, 0, 'L', 0);
    $pdf->Cell(40, 5, number_format($fattura["imponibile"], 2, ',', '.'), 1, 1, 'R', 0);
    foreach($fattura["iva"] as $iva => $value) {
        $pdf->Cell(40, 5, "I.V.A. $iva%", 1, 0, 'L', 0);
        $pdf->Cell(40, 5, number_format($value, 2, ',', '.'), 1, 1, 'R', 0);
    }
    $pdf->SetFont('','', 8);
    $pdf->Cell(40, 5, "Costi bancari", 1, 0, 'L', 0);
    $pdf->Cell(40, 5, number_format($fattura["banca"], 2, ',', '.'), 1, 1, 'R', 0);
    $pdf->SetFont('','B', 12);
    $pdf->Cell(40, 5, "Totale", 1, 0, 'L', 0);
    $pdf->SetTextColor(200, 0, 0);
    $pdf->Cell(40, 5, number_format($fattura["totale"], 2, ',', '.'), 1, 1, 'R', 0);

    //-----------------------------------------------------------------------
    $pdf->Output("Fattura-{$fattura["anno"]}-{$fattura["numero"]}.pdf", 'D');
}



?>
