<?php
GLOBAL $tipi_turno, $session, $anagrafiche;

$db = getDB();
$result = new Result();

// $result->setResult(true);
// $result->setCode("OK");
// $result->setDescription("OK!");
// $result->setLevel(Result::INFO);
// $result->setCustoms(['url' => "/"]);
// echo $result->toJson();
// exit();

$session->log("************************************************************");
$session->log("* GENERAZIONE TURNI");
$session->log("************************************************************");

###################################################################
$sql = "select * from fn_azzera_tutto();";
$rs = $db->Esegui($sql);#$session->log($sql);

if ($rs === false) {
    $result->setResult(false);
    $result->setCode("KO");
    $result->setDescription("Impossibile cancellare i turni.");
    $result->setLevel(Result::ERROR);
    #$result->setCustoms(['url' => "/"]);
    echo $result->toJson();
    exit();
}


$session->log("AZZERAMENTO OK");

/*
  SELECT 
        tipo_giornata, tipo, t.code_anagrafica, 
        sum(ttg.ore) as ore_guardia, count(*) as c
        FROM turni t
        left join tipo_turni_guardia ttg ON t.tipo_turno=ttg.code
        --left join destinazioni d ON t.tipo_turno=d.code
        where data BETWEEN date '2016-02-01' AND date '2016-09-30'
        and tipo_turno like 'CARDIO\_%'
        group by t.code_anagrafica, tipo_giornata, tipo
        order by tipo_giornata, tipo, count(*) desc, code_anagrafica;
*/

$obj_calendario = Calendario::getInstance();

$data_inizio = $_SESSION['PLANNING_data_inizio'];
$data_fine = $_SESSION['PLANNING_data_fine'];

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a'));
if (strlen($data_fine) == 0)
    $data_fine = $obj_calendario->getData($data_inizio, $giorni_planning);
$session->log("INIZIO: ".$data_inizio);

$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('B');
$obj_planning->setGiorni($giorni_planning);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
$obj_planning->setTipiTurnoGuardie($tipi_turno);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();


$calendario = $obj_calendario->getCalendario();
$guardie = $obj_planning->getGuardie();
$planner = new PlannerCardiologia();

$RIPOSI_DOPO_18 = 0;
$RIPOSI_PRIMA_12 = 0;




/*
 * GUARDIE 
 * Procediamo prima con tutte le festivit, poi passiamo ai festivi.
 * Facciamo infine tutti lgi altri giorni (feriali).
 */
$turno_extra = 0;


/*
 * FASE 1: FESTIVITA'
 */
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita']==0 && $giorno['festivita']==0)
        continue;
    
    $code_giornata = 'FESTIVITA';
    
    # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
    # primo giorno, viene fatto anche il secondo seguendo uno schema.
    # Verifichiamo ogni 2 turni di festa o quantomeno se oggi  festa mentre
    # l'indomani non  festa.
    # Esempio: 3 giorni di festa, prefestivo o prefestivit compresi.
    # I primi 2 giorni fanno un conto, l'ultimo un altro.
    # I giorni singoli vanno sempre in POST.
    if ($giorno['festa'])
        $turno_extra++;
    $session->log("{$data} --> {$code_giornata} ({$turno_extra})");
    

		
    # --------------------------------------------------------------------------
    # CARDIO_UTIC_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_UTIC_NOTTE';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    /*
    # --------------------------------------------------------------------------
    # CARDIO_MAT_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_UTIC';
    $cardiologo_mattino_utic = false;
    if ($giorno['festa']) {
        $session->log("-- cerco ".$tipo_turno);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $session->log("-- cerco ".$tipo_turno);
        $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
    }
    */
}

/*
 * FASE 2: FESTIVI SABATI e DOMENICHE
 */
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita']==1 || $giorno['festivita']==1)
        continue;
    if ($giorno['festa']==0)
        continue;
    $code_giornata = 'FESTIVO';
    
    # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
    # primo giorno, viene fatto anche il secondo seguendo uno schema.
    # Verifichiamo ogni 2 turni di festa o quantomeno se oggi  festa mentre
    # l'indomani non  festa.
    # Esempio: 3 giorni di festa, prefestivo o prefestivit compresi.
    # I primi 2 giorni fanno un conto, l'ultimo un altro.
    # I giorni singoli vanno sempre in POST.
    if ($giorno['festa'])
        $turno_extra++;
    $session->log("{$data} --> {$code_giornata} ({$turno_extra})");
    
               
		
    # --------------------------------------------------------------------------
    # CARDIO_UTIC_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_UTIC_NOTTE';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    /*
    # --------------------------------------------------------------------------
    # CARDIO_MAT_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_UTIC';
    $cardiologo_mattino_utic = false;
    if ($giorno['festa']) {
        $session->log("-- cerco ".$tipo_turno);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $session->log("-- cerco ".$tipo_turno);
        $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
    }
    */
}


/*
 * FASE 3: GIORNI FERIALI
 */
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    # --------------------------------------------------------------------------
    # CARDIO_UTIC_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_UTIC_NOTTE';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # RIPOSO DI RECUPERO ORE dopo la notte
    # per ora solo il giorno successivo. Se festivo, non lo trasliamo.
    /*$riposi = 0;
    $i = 0;
    while ($riposi < 1) {
        $i++;
        $festa = $obj_calendario->festa($data, $i);
        if (!$festa) {
            $g = $obj_calendario->getData($data, $i);
            $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere gi settato
            $riposi++;
        }
    }*/
    
    /*
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    $session->log("-- cerco ".$tipo_turno);
    $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    */
}

$session->log('FINE GUARDIE');


/*
 * FASE 4.1: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI OBBLIGATORIE
 */

$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY obbligatoria DESC, ordine";
$rs = $db->Esegui($sql);
$destinazioni_ordinate_priorita = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $destinazioni_ordinate_priorita[$code] = $rs->FetchRow();
}

$turno_extra = 0;
$obj_planning = Planning::getInstance();  
$obj_calendario = Calendario::getInstance();  
$calendario = $obj_calendario->getCalendario();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e cos via.
    # NON PIU'!!!
    
    $severita = array('BIANCO', 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
    foreach ($destinazioni_ordinate_priorita as $key => $destinazione) {
        if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
            continue;
        #if ($key == "DEGDS" && ($calendario[$data]['gsettimana'] == 'Mer' || $calendario[$data]['gsettimana'] == 'Gio' || $calendario[$data]['gsettimana'] == 'Ven')) {
        #    $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], 'BIANCO', 'ABB');
        #    continue;
        #}
            
        if ($destinazione["obbligatoria"] != 'S')
            continue;
            
        # Se  gi impostato, salto:
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
        if (strlen($giornata_pl['code_anagrafica']) > 0)
            continue;
                
        $ne_manca_qualcuno = false;
        foreach ($severita as $s) {
            
            $session->log("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se  l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        #if ($ne_manca_qualcuno === false)
        #    break;
    }
}

/*
 * FASE 4.2: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI NON OBBLIGATORIE
 */
 
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e cos via.
    
    $severita = array('BIANCO', 'GIALLO', /*'ARANCIO',*/ 'ROSSO');
    foreach ($severita as $s) {
        $ne_manca_qualcuno = false;
        foreach ($destinazioni_ordinate_priorita as $key => $destinazione) {
            if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
                continue;
            if ($destinazione["obbligatoria"] == 'S')
                continue;
            $session->log("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se  l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        if ($ne_manca_qualcuno === false)
            break;
    }
}

/*
 * FASE 5: MEDICI DISPONIBILI (SOLO GIORNI FERIALI)
 */
/*$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    foreach($anagrafiche as $code => $anag) {
        $data_inizio = $anag["data_inizio"];
        $data_fine = $anag["data_fine"];
        if (strlen($data_fine) == 0)
            $data_fine = '2100-12-31';
        
        if ($data < $data_inizio || $data > $data_fine) 
            continue;
        if (!isset($turni[$code][$data])) {
            $obj_planning->insertTurno($data, 'DISP', 'FERIALE', $code); 
        }
    }
}*/

$result->setResult(true);
$result->setCode("OK");
$result->setDescription("Turni calcolati con successo.");
$result->setLevel(Result::INFO);
$result->setCustoms(['url' => "/"]);
echo $result->toJson();


$session->log("FINE");
exit();
?>
