<?php
@session_start();
ob_start();

require_once 'customs.inc.php';

spl_autoload_register('autoload');
set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB'.PATH_SEPARATOR.'/var/www/LIB/swiftmailer/classes');
require_once("aspidenet-yae/aspidenet.inc.php");
require_once 'function.inc.php';
#require_once('classes/medoo.class.php');
require_once('classes/utente.class.php');
require_once('classes/session.class.php');

require_once __DIR__ . '/vendor/autoload.php';

require_once("classes/result.class.php");
require_once("classes/geo.class.php");
require_once("classes/calendario.class.php");
require_once("classes/planning.class.php");
require_once("classes/plannercardiologia.class.php");

require_once('adodb5/adodb.inc.php');
$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC; //ADODB_FETCH_BOTH;


$NO_JS_CHECK = true;
$stampa = 0;


#---------------------------------------------------------------------------
# SESSION
#---------------------------------------------------------------------------
if (isset($_SESSION['SESSION'])) {
    $session = unserialize($_SESSION['SESSION']);
}
else {
    $session = new Session();
}




 
function autoload($className) {
    @ include_once 'classes/' . strtolower($class_name) . '.class.php';
}










/*******************************************************************************
   TOR NETWORK CHECK
*******************************************************************************/
if (!isset($_SESSION["TOR"])) {
    if (IsTorExitPoint()) {
        $_SESSION["TOR"] = true;
    }else{
        $_SESSION["TOR"] = false;
    }
}

/*******************************************************************************
   GETTEXT
*******************************************************************************/
if (isset($_GET["locale"])) {
    $locale = $_GET["locale"];
}
elseif (isset($_SESSION["locale"])) {
    $locale  = $_SESSION["locale"];
}
else {
    $lang = explode (",", $_SERVER['HTTP_ACCEPT_LANGUAGE']);
    $locale = $lang[0];
}
$_SESSION["locale"] = $locale; 
if (strtolower($locale) == "it" || strtolower($locale) == "it-it" || strtolower($locale) == "it_it") {
    $locale = "it_IT.UTF-8";
    $LANG = 'it';
}
else {
    $locale = "en_US.UTF-8";
    $LANG = 'en';
}
#$locale = "en_US.UTF-8";
#$LANG = 'en';
#echo $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    
$directory = dirname(__FILE__).'/locale';
putenv("LANG=" . $locale); 
setlocale(LC_MESSAGES, $locale);
$domain = "phoenix";
$results = bindtextdomain($domain, $directory); 
$results = textdomain($domain);
bind_textdomain_codeset($domain, 'UTF-8');

$smarty = $session->smarty();


/*******************************************************************************
   TOR NETWORK CHECK
*******************************************************************************/
if ($_SESSION["TOR"]) {
    #echo "TOR=SI";
    $messaggio["titolo"] = "Impossibile utilizzare";
    $messaggio["descrizione"] = "La connessione corrente proviene da una rete non gradita, prego utilizzare la propria connessione casalinga.<br>Per maggiori informazioni, scrivici a <a href=\"mailto:support@mariobid.com\">support@mariobid.com</a>.";
    $messaggio["url_back"] = "/";
    $messaggio["link_back"] = "OK";
    $smarty->assign("messaggio", $messaggio);
    $smarty->display("messaggio.tpl");
}

/*******************************************************************************
   CHECK JS interprete
*******************************************************************************/
if (get("ok_check_js", 0) == 1) {
    $check_code = get("check_code");
    #error_log("Check code = ".$check_code);
    if ($check_code == $_SESSION["CHECK_JS_CODE"]) {
        $_SESSION["CHECK_JS_OK"] = true;
        header("Location:".$_SESSION["CHECK_JS_URL"]);
        exit();
    }
}
elseif (!isset($_SESSION["CHECK_JS_OK"]) && (!isset($NO_JS_CHECK) || $NO_JS_CHECK === false)) {
    error_log("Check code non confermato. URI: ".$_SERVER["REQUEST_URI"]);
    $_SESSION["CHECK_JS_CODE"] = md5(microtime());
    $_SESSION["CHECK_JS_URL"] = $_SERVER["REQUEST_URI"];
    
    $smarty->assign("reload_page", $_SERVER["REQUEST_URI"]);
    $smarty->assign("check_code", $_SESSION["CHECK_JS_CODE"]);
    $smarty->display("check-browser.tpl");
    exit();
}

/*******************************************************************************
   CONTEXT MOBILE or WEB
*******************************************************************************/
$useragent=$_SERVER['HTTP_USER_AGENT'];
if (isset($_GET["context"])) {
    switch ($_GET["context"]) {
        case "mobile":
            $CONTEXT = "mobile";
            break;
        case "web":
        default:
            $CONTEXT = "web";
            break;
    }
}
elseif (isset($_SESSION["CONTEXT"])) {
    $CONTEXT  = $_SESSION["CONTEXT"];
}
else {
    $CONTEXT = "web";
if(preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4)))
    $CONTEXT = "mobile";
}
$CONTEXT = "mobile";
$_SESSION["CONTEXT"] = $CONTEXT; 


$smarty->assign("CONTEXT", $CONTEXT);

#---------------------------------------------------------------------------
# UTENTE
#---------------------------------------------------------------------------
$social_pixel_code = true;
$user_token = md5(session_id());
if (isset($_SESSION['USER'])) {
    $user = unserialize($_SESSION['USER']);
    #error_log(var_export($user, true));
    $login = true;
    # rifaccio la query perche' devo ricaricare i valori dei conti BID/EURO
    update_session_user($user_token);
    //setcookie("USER_TOKEN", $user_token, time()+3600*24*30);
}
else {
    $login = false;
    $user = new Utente();
}
if (TEST)
    $social_pixel_code = false;
    

$smarty->assign("login", $login);
$smarty->assign("USER", $user);
$smarty->assign("session_id", session_id());
#$smarty->assign("sessione", md5(session_id()));
$smarty->assign("currentpage", $_SERVER['PHP_SELF']);
$smarty->assign("social_pixel_code", $social_pixel_code);
$smarty->assign("meta_canonical", "");
$smarty->assign("meta_description", "");




if (get("debug", 0))
    print_r($_SESSION);

#---------------------------------------------------------------------------
# DAYLIGHT SAVING
#---------------------------------------------------------------------------
$oggi = date_create(date('Y-m-d'));
#$daylight_offset = "+0" . (date_offset_get($oggi)/3600) . ":00";
$daylight_offset = "+01:00";
$smarty->assign("daylight_offset", $daylight_offset);























$db = getDB();


/*******************************************************************************
  TIPI TURNO GUARDIA
*******************************************************************************/
$sql = "SELECT code, turno, ore FROM tipo_turni_guardia 
        WHERE code_uo='cardiologia' ORDER BY ordine";
$rs = $db->Esegui($sql);
$tipi_turno = array();
$ore_dei_turni = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $tipo = $rs->Fields("turno");
    $tipi_turno[$code] = $tipo;
    $ore_dei_turni[$code] = $rs->Fields("ore");
    $rs->MoveNext();
}
$smarty->assign('tipi_turno', $tipi_turno);


/*******************************************************************************
  TIPI TURNO SPECIALI
*******************************************************************************/
$tipi_turno_ext = array(
    'R' => "Riposo",
    'F' => "Ferie",
    'C' => "Congresso",
    'I' => "Indisponibile",
    'DISP' => "Disponibile",
);
$smarty->assign('tipi_turno_ext', $tipi_turno_ext);

/*******************************************************************************
  ANAGRAFICHE E POOL
*******************************************************************************/
$sql = "SELECT * FROM anagrafiche WHERE valido ORDER BY pool, code";
$rs = $db->Esegui($sql);
$anagrafiche = array();
$guardiani = array();
$pools = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $pool = $rs->Fields("pool");
    $guardia = $rs->Fields("guardia");
    if (isset($pools[$pool]))
        $pools[$pool]++;
    else
        $pools[$pool] = 1;
        
    $anag = $rs->FetchRow();
    
    if ($guardia == 'S')
        $guardiani[$code] = $anag;
        
    $anagrafiche[$code] = $anag;
}
$smarty->assign('anagrafiche', $anagrafiche);

/*******************************************************************************
  DESTINAZIONI E POOL
*******************************************************************************/
$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY ordine_visuale, pool, code";
$rs = $db->Esegui($sql);
$destinazioni = array();
$count_destinazioni_pool = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $pool = $rs->Fields("pool");
    $ore_dei_turni[$code] = $rs->Fields("ore");
    
    if ($code == 'DISP') {
        $rs->MoveNext();
        continue;
    }    
    
    if (isset($count_destinazioni_pool[$pool]))
        $count_destinazioni_pool[$pool]++;
    else
        $count_destinazioni_pool[$pool] = 1;
    $destinazioni[$code] = $rs->FetchRow();
}
$smarty->assign('destinazioni', $destinazioni);
