<?php
@session_start();
ob_start();

require_once 'index.inc.php';


$klein = new \Klein\Klein();

// Using range behaviors via if/else
$klein->onHttpError(function ($code, $router) {
    GLOBAL $session;
    
    if ($code >= 400 && $code < 500) {
        #$router->response()->body(
        #    'Oh no, a bad error happened that caused a '. $code
        #);
        
        $session->smarty->assign("messaggio", [
            "titolo" => "Errore {$code}",
            "descrizione" => "Il contenuto richiesto non esiste o non &egrave; pi&ugrave; presente a questo indirizzo.",
            "tipo" => "ERROR",
            "links" => []
        ]);
    } 
    elseif ($code >= 500 && $code <= 599) {
        #error_log('uhhh, something bad happened');
        $session->smarty->assign("messaggio", [
            "titolo" => "Errore {$code}",
            "descrizione" => "La pagina richiesta &egrave; andata in errore. Prego riprovare o contattare il servizio di supporto.",
            "tipo" => "ERROR",
            "links" => []
        ]);
    }
    $session->smarty->display("messaggio.tpl");
});

$klein->respond('GET', '*', function ($request, $response, $service, $app) {
        GLOBAL $session;
        $session->log("------------------------------------------------------");
        $session->log($request->method()." URI: ".$request->uri());
        $session->log("------------------------------------------------------");
    });



/***********************************************************************************************
* LOGOUT
***********************************************************************************************/
$klein->respond('GET', '/logout', function ($request, $response, $service) {
    error_log("GET /logout");
    #$service->render("logout.php");
    setcookie('USER_TOKEN', null, -1);
    session_unset();
    session_destroy();
    header("Location:/");
    exit();
});

/***********************************************************************************************
* LOGIN
***********************************************************************************************/
$klein->respond('GET', '/login', function ($request, $response, $service) {
    GLOBAL $session;
    error_log("GET /login");
    #$service->render("login.php");
    if ($session->checkLogin()) { 
        header("Location:/");
        exit();
    }
    $session->smarty->display("login.tpl");
});
#-----------------------------------------------------------------------------------------------
$klein->respond('POST', '/login', function ($request, $response, $service) {
    GLOBAL $session;
    error_log("POST /login");
    $params = $request->params(); #json_decode(file_get_contents('php://input'),true); #
    $LOGIN_PAGE = true;
    $user = $session->user();
    $username = get("username", "", $params);
    $password = get("password", "", $params);
    $result = new Result();
    
    try {
        $res = $user->login(trim($username), trim($password));
        if ($res) {
            $_SESSION['USER'] = serialize($user);
            if ($session->get("REDIRECT_URL_AFTER_LOGIN") === false)
                return "OK";
            else {
                $result->setResult(true);
                $result->setCode("OK");
                $result->setDescription("Login effettuata con successo.");
                $result->setLevel(Result::INFO);
                $result->setCustoms(['url' => $session->get("REDIRECT_URL_AFTER_LOGIN")]);
                return $result->toJson();
            }
        }
    }
    catch (Exception $ex) {
        $result->setResult(false);
        $result->setCode("KO");
        $result->setDescription($ex->getMessage());
        $result->setLevel(Result::ERROR);
        return $result->toJson();
    }
    $result->setResult(false);
    $result->setCode("KO");
    $result->setDescription("Accesso fallito. Verificare nome utente e password.");
    $result->setLevel(Result::ERROR);
    return $result->toJson();
});



#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
#
# PARTE PRIVATA
#
#xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

/***********************************************************************************************
* HOME
***********************************************************************************************/
$klein->respond('GET', '/', function ($request, $response, $service) {
    GLOBAL $session;
    error_log("GET /");
    $session->assertLogin();
    #$session->smarty->display("home.tpl");
    $service->render("progetta_guardie.php");
});

# Cambia turno
$klein->respond(array('GET', 'POST'), '/turni/[:data]/[:tipo_turno]/?[:code_anagrafica]?', function ($request, $response, $service) {
    GLOBAL $session, $tipi_turno, $destinazioni, $anagrafiche;
    $db = getDB();
    $session->assertLogin();
    $data = $request->data;
    $tipo_turno = $request->tipo_turno;
    $code_anagrafica = $request->code_anagrafica;
    error_log("GET /turni/$data/$tipo_turno/$code_anagrafica");
    
    $obj_calendario = Calendario::getInstance();
    $obj_calendario->setDataInizio($data);
    $obj_calendario->setGiorni(1);
    $obj_calendario->init();
    #Calendario::save();
    $calendario = $obj_calendario->getCalendario();

    $planner = new PlannerCardiologia();

    #-------------------------------------------------------------------------------
    # MEDICI DISPONIBILI
    #-------------------------------------------------------------------------------
    $disponibili = $_SESSION["MEDICI_DISPONIBILI"];

    #-------------------------------------------------------------------------------
    # MEDICI CHE LAVORANO (piano + guardie)
    #-------------------------------------------------------------------------------
    $obj_planning = Planning::getInstance();
    $obj_planning->setDB($db);
    $obj_planning->setStato('B');
    $obj_planning->setGiorni(1);
    $obj_planning->setDataInizio($data);
    $obj_planning->setDataFine($data);
    $obj_planning->setTipiTurnoGuardie($tipi_turno);
    $obj_planning->init();
    $obj_planning->load();
    $guardie = $obj_planning->getGuardie();
    $turni = $obj_planning->getTurni();
    $piano_lavoro = $obj_planning->getPianoLavoro();
        
    foreach($tipi_turno as $code_turno => $item) {
        #echo $guardie[$data][$code_turno]["code_anagrafica"]." ";
        $sigla = $guardie[$data][$code_turno]["code_anagrafica"];
        if (strlen($sigla))
            $lavoratori[$sigla] = $anagrafiche[$sigla];
    }
    foreach($destinazioni as $code_turno => $item) {
        #echo $piano_lavoro[$data][$code_turno]["code_anagrafica"]." ";    
        $sigla = @$piano_lavoro[$data][$code_turno]["code_anagrafica"];
        if (strlen($sigla)) {
            $lavoratori[$sigla] = $anagrafiche[$sigla];
            $lavoratori_piano[$sigla] = $anagrafiche[$sigla];
        }
    }
    if ($calendario[$data]["festa"] && ($tipo_turno == "EMOREP" || $tipo_turno == "EMO1" || $tipo_turno == "EMO2")) {
        $disponibili[$data]['ABB'] = $anagrafiche['ABB'];
        $disponibili[$data]['BAL'] = $anagrafiche['BAL'];
        $disponibili[$data]['GIA'] = $anagrafiche['GIA'];
        $disponibili[$data]['VIS'] = $anagrafiche['VIS'];
        $disponibili[$data]['POR'] = $anagrafiche['POR'];
    }
    elseif ($calendario[$data]["festa"] && $tipo_turno != "EMOREP") {
        
        foreach($anagrafiche as $code => $anag) {
            if (!isset($turni[$code][$data]) || isset($turni[$code][$data]['DISP'])) {
                $disponibili[$data][$code] = $anag;
            }
        }
    }

    $method = $request->method();
    
    if ($method != 'POST') {
        $session->smarty->assign("disponibili", $disponibili[$data]);
        $session->smarty->assign("lavoratori", $lavoratori);
        $session->smarty->assign("lavoratori_piano", $lavoratori_piano);
        $session->smarty->assign("stato", $piano_lavoro[$data][$tipo_turno]["stato"]);
        $session->smarty->assign("data", $data);
        $session->smarty->assign("tipo_turno", $tipo_turno);
        $session->smarty->assign("code_anagrafica", $code_anagrafica);
        $session->smarty->display('cambia_guardia.tpl');
    }
    else {
        $session->log($_POST);
        $cambia_con = $_POST["cambia_con"];
        $doppio_con = $_POST["doppio_con"];
        $inverti_con = $_POST["inverti_con"];
        
        # SE NON DEVE CAMBIARE NULLA
        if ($cambia_con == "LASCIA" && $doppio_con == "NODOPPIO" && $inverti_con == "NONINVERTIRE")
            exit();
            
        #print_r($_POST);
        
        if ($cambia_con == "LASCIA")
            $cambia_con = $doppio_con;
        
        
        
        # SE POSTAZIONE VA SVUOTATA
        if ($cambia_con == "VUOTO") {
            # Quanti turni fa?
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' AND code_anagrafica='{$code_anagrafica}'";
            $rs = $db->Esegui($sql); #echo $sql;
            
            # leggo eventuali leganti
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' AND code_anagrafica='{$code_anagrafica}' AND tipo_turno='{$tipo_turno}'";
            $rs2 = $db->Esegui($sql); #echo $sql;
            $legante = $rs2->Fields("legante");
            
            # Se fa pi di un turno, questo va cancellato
            if ($rs->RecordCount() > 1) {
                $sql = "DELETE FROM turni
                        WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}' AND stato='B'";
                $db->Esegui($sql); #echo $sql;
            }
            # altrimenti questo va messo disponibile
            else {
                $sql = "UPDATE turni SET tipo_turno='DISP', legante=null
                        WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}' AND stato='B'";
                $db->Esegui($sql); #echo $sql;
            }
            # elimino i riposi collegati se ci sono
            if (strlen($legante)) {
                $sql = "DELETE FROM turni
                        WHERE data<>'{$data}' AND tipo_turno='R' AND code_anagrafica='{$code_anagrafica}' AND legante='{$legante}' AND stato='B'";
                $db->Esegui($sql); #echo $sql;
            }
            echo "OK";
        }
        # SE POSTAZIONE VA UN DISPONIBILE ED E' AL MOMENTO VUOTA
        elseif ($code_anagrafica == "") {
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' AND tipo_turno='DISP' AND code_anagrafica='{$cambia_con}'";
            $rs = $db->Esegui($sql); 
            #echo $sql."<br>";
            /*if ($rs->RecordCount() > 0) {
                $sql = "UPDATE turni SET tipo_turno='{$tipo_turno}'
                        WHERE data='{$data}' AND tipo_turno='DISP' AND code_anagrafica='{$cambia_con}' AND stato='B'";
                $db->Esegui($sql); 
                #echo $sql."<br>";
            }
            else {
                $sql = "INSERT INTO turni (data, tipo_turno, code_anagrafica, stato)
                        VALUES ('{$data}', '{$tipo_turno}', '{$cambia_con}', 'B')";
                $db->Esegui($sql); 
                #echo $sql."<br>";
            }*/
            $sql = "DELETE FROM turni
                    WHERE data='{$data}' AND tipo_turno='DISP' AND code_anagrafica='{$cambia_con}' AND stato='B'";
            $db->Esegui($sql); #echo $sql;
            
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' LIMIT 1";
            $rs = $db->Esegui($sql); 
            $tipo_giornata = $rs->Fields("tipo_giornata");
            
            $planner->impostaGuardia($data, $tipo_turno, $tipo_giornata, $cambia_con);
                
            echo "OK";
        }
        # SE INVERSIONE CON ALTRA POSTAZIONE
        elseif ($inverti_con != "NONINVERTIRE") {
            # Qui 
            $sql = "SELECT id FROM turni
                    WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}'";
            $rs = $db->Esegui($sql); 
            #echo $sql."<br>";
            if ($rs->RecordCount() > 0) {
                $id_turno_sorgente = $rs->Fields("id");
            }
            
            # Qui 
            $sql = "SELECT id FROM turni
                    WHERE data='{$data}' AND code_anagrafica='{$inverti_con}' AND tipo_turno IN (SELECT code FROM destinazioni)";
            $rs = $db->Esegui($sql); 
            #echo $sql."<br>";
            if ($rs->RecordCount() > 0) {
                $id_turno_destinazione = $rs->Fields("id");
            }
            
            $sql = "UPDATE turni SET code_anagrafica='{$code_anagrafica}'
                    WHERE data='{$data}' AND code_anagrafica='{$inverti_con}' AND id={$id_turno_destinazione}";
            $db->Esegui($sql); 
            
            $sql = "UPDATE turni SET code_anagrafica='{$inverti_con}'
                    WHERE data='{$data}' AND code_anagrafica='{$code_anagrafica}' AND id={$id_turno_sorgente}";
            $db->Esegui($sql); 
            
            echo "1";
        }
        # SE TURNO SPECIALE
        elseif ($tipo_turno == "C" || $tipo_turno == "I" || $tipo_turno == "F" || $tipo_turno == "R" || $tipo_turno == "DISP") {
            $sql = "UPDATE turni SET tipo_turno='{$cambia_con}', stato='B'
                    WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}' /*AND stato='B'*/";
            $db->Esegui($sql); #echo $sql;
            echo "OK";
        }
        
        # SE POSTAZIONE VA UN DISPONIBILE ED E' AL MOMENTO DI UN ALTRO
        elseif ($code_anagrafica != "") {
            # Qui cambio il nuovo
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' AND tipo_turno='DISP' AND code_anagrafica='{$cambia_con}'";
            $rs = $db->Esegui($sql); 
            #echo $sql."<br>";
            if ($rs->RecordCount() > 0) {
                $sql = "UPDATE turni SET tipo_turno='{$tipo_turno}'
                        WHERE data='{$data}' AND tipo_turno='DISP' AND code_anagrafica='{$cambia_con}' AND stato='B'";
                $db->Esegui($sql); 
                #echo $sql."<br>";
            }
            else {
                $sql = "INSERT INTO turni (data, tipo_turno, code_anagrafica, stato)
                        VALUES ('{$data}', '{$tipo_turno}', '{$cambia_con}', 'B')";
                $db->Esegui($sql); 
                #echo $sql."<br>";
            }
            
            # Qui cambio il vecchio
            
            # Quanti turni fa?
            $sql = "SELECT * FROM turni
                    WHERE data='{$data}' AND code_anagrafica='{$code_anagrafica}'";
            $rs = $db->Esegui($sql); #echo $sql;
            
            # Se fa pi di un turno, questo va cancellato
            if ($rs->RecordCount() > 1) {
                $sql = "DELETE FROM turni
                        WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}' AND stato='B'";
                $db->Esegui($sql); #echo $sql;
            }
            # altrimenti questo va messo disponibile
            else {
                $sql = "UPDATE turni SET tipo_turno='DISP'
                        WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND code_anagrafica='{$code_anagrafica}' AND stato='B'";
                $db->Esegui($sql); #echo $sql;
            }
            
            echo "OK";
        }
    }
});





/***********************************************************************************************
* FERIE
***********************************************************************************************/
$klein->respond('GET', '/ferie', function ($request, $response, $service) {
    GLOBAL $session;
    error_log("GET /ferie");
    $session->assertLogin();
    $session->smarty->display("ferie.tpl");
});
$klein->respond('GET', '/ferie/importa', function ($request, $response, $service) {
    GLOBAL $session, $anagrafiche;
    error_log("GET /ferie/importa");
    $session->assertLogin();
    $session->smarty->assign("anagrafiche", $anagrafiche);
    $session->smarty->display("form-ferie.tpl");
});
$klein->respond('POST', '/ferie/importa', function ($request, $response, $service) {
    GLOBAL $session, $anagrafiche;
    error_log("POST /ferie/importa");
    $session->assertLogin();
    $nome_campo = "file_ferie";
    $db = getDB();
    $code_anagrafica = $_POST["anagrafica"];
    if (!array_key_exists($code_anagrafica, $anagrafiche))
        die("Anagrafica non esiste!");
    
    if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
        
        
        require_once('classes/simplexlsx.class.php');
        require_once('classes/plannercardiologia.class.php');


        error_log("ok-is_uploaded_file");
        #print_r($_FILES[$nome_campo]);
        $originale = basename($_FILES[$nome_campo]['tmp_name']);
        $path_parts = pathinfo($_FILES[$nome_campo]['name']);
        $extension = strtoupper($path_parts['extension']);
        
        $tmp_name = $_FILES[$nome_campo]['tmp_name'];
        $tipo = $_FILES[$nome_campo]['type'];
        
        error_log("EXT: {$extension}");
        // if (!in_array($extension, $ext_enable)) {
            // $errore = true;
            // #show_message(MSGERROR, "Formato file non permesso!", false);
            // #throw new Exception("Formato file non permesso!");
        // }

        $ret["name"] = $name;
        $ret["extension"] = $extension;
        
        
        $xlsx = new SimpleXLSX($tmp_name);
        if ($xlsx->success()) {
            #$session->log( $xlsx->rows() );
            
            $rows = $xlsx->rows();
            $planner = new PlannerCardiologia();
            
            echo "<table border=1>";
            foreach($rows as $r => $item) {
                echo "<tr>";
                foreach($item as $c => $value) {
                
                    echo "<td>{$value}";
                    if (in_array(strtoupper($value), array('F', 'I', 'C', 'D')))
                        echo " ({$c})";
                    echo "</td>";
                
                }
                echo "</tr>";
            }
            echo "</table>";
            
            for($i=0; $i<30; $i++) {
                $value = $rows[$i][0];
                if ($value >= date('Y')) {
                    echo "<br>$i) {$rows[$i][0]}<br>";
                    $anno = $rows[$i][0];
                    $i++;
                    echo "-- {$rows[$i][0]}<br>";
                    $mese = $rows[$i][0];
                    $i++;
                    
                    for($j=1; $j<=31; $j++) {
                        
                        $content = $rows[$i][$j];
                        if (in_array(strtoupper($content), array('F', 'I', 'C', 'D'))) {
                            echo " {$j}={$content}, ";
                            $tipo_ferie = strtoupper($content);
                            
                            $data_inizio = $data_fine = "{$anno}-{$mese}-{$j}";
                            
                            
                            $sql = "DELETE FROM turni
                                    WHERE data BETWEEN '{$data_inizio}' AND '{$data_fine}'
                                    AND code_anagrafica='{$code_anagrafica}' 
                                    --AND tipo_turno='DISP'";
                            $rs = $db->Esegui($sql);
                            
                            // $sql = "SELECT * FROM turni
                                    // WHERE data BETWEEN '{$data_inizio}' AND '{$data_fine}'
                                    // AND code_anagrafica='{$code_anagrafica}'
                                    // ORDER BY data";
                            // $rs = $db->Esegui($sql);
                            if (!$rs) {
                                error_log('ko');
                                echo "ko";
                                exit();
                            }
                            
                            error_log("$code_anagrafica, $data_inizio, $data_fine, $tipo_ferie");
                            $planner->impostaFerie2($code_anagrafica, $data_inizio, $data_fine, $tipo_ferie);
                        }
                    }
                }
            }
            
            
            
        } else {
            error_log( 'xlsx error: '.$xlsx->error());
        }
    }
    
    exit('fine');
});



/***********************************************************************************************
* LOG
***********************************************************************************************/
$klein->respond('GET', '/log/guardie/[:data]/[:tipo_turno]', function ($request, $response, $service) {
    GLOBAL $session;
    $session->assertLogin();
    $db = getDB();
    $data = $request->data;
    $tipo_turno = $request->tipo_turno;
    error_log("GET /log/guardie/$data/$tipo_turno");
    
    echo <<<EOT
    <h3>{$tipo_turno} del {$data}</h3>
EOT;

    $sql = "SELECT * FROM log_guardie WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND stato IN ('B', 'P') ORDER BY data";
    $rs = $db->Esegui($sql);
    $log = array();
    if ($rs === false); {
        $log = $rs->GetArray();
    }

    $first = true;
    echo "<table border='0'>";
    foreach($log as $item) {
        echo "<tr>";
        echo "<td>{$item['severita']}</td>";
        
        $list = json_decode($item['lista']);
        echo "<td><table border='1' style='font-size:0.9em;'>";
        foreach($list as $i) {
            if ($first) {
                echo "<tr>";
                foreach($i as $k => $j) {
                    echo "<th>{$k}</th>"; 
                }
                echo "</tr>"; 
                $first = false;
            }
                
            
            echo "<tr>";
            
            foreach($i as $j) {
                echo "<td>{$j}</td>"; 
            }
            
            echo "</tr>"; 
        }
        echo "</table></td>";
        echo "</tr>"; 
    }
    echo "</table>";



    $sql = "SELECT * FROM log_guardie_verifiche WHERE data='{$data}' AND tipo_turno='{$tipo_turno}' AND stato IN ('B', 'P') ORDER BY data, ct";
    $rs = $db->Esegui($sql);
    $log2 = array();
    if ($rs === false); {
        $log2 = $rs->GetArray();
    }

    $first = true;
    echo "<table border='0'>";
    foreach($log2 as $item) {
        if ($first) {
            echo "<tr>";
            foreach($item as $k => $i) {
                echo "<th>{$k}</th>"; 
            }
            echo "</tr>"; 
            $first = false;
        }
        echo "<tr>";
        foreach($item as $i) {
            echo "<td>{$i}</td>"; 
        }
        echo "</tr>"; 
    }
    echo "</table>";
});
#------------------------------------------------------------------------------------------------------------
$klein->respond('GET', '/log/candidati/[:data]/[:tipo_turno]', function ($request, $response, $service) {
    GLOBAL $session;
    $session->assertLogin();
    $db = getDB();
    $data = $request->data;
    $tipo_turno = $request->tipo_turno;
    error_log("GET /log/candidati/$data/$tipo_turno");
    
    $sql = "select tipo_giornata from turni where data='{$data}' AND char_length(tipo_giornata)>0 limit 1";
    $rs = $db->Esegui($sql);
    $code_giornata = $rs->Fields("tipo_giornata");

    echo <<<EOT
    <h3>{$tipo_turno} del {$data} (registro: {$code_giornata})</h3>
EOT;


    $sql = "SELECT g.code as giornata, t.code as turno, a.code as anagrafica, coalesce(count, 0) as numero, max as ultima_data
            , (coalesce(count, 0) / date_part('day', to_timestamp('{$data}', 'YYY-MM-DD') - a.data_inizio::date)) as coeff_guardia
            from tipo_giornate g
            cross join tipo_turni_guardia t 
            cross join anagrafiche a
            left join temp ON temp.code_anagrafica=a.code AND temp.tipo_turno=t.code AND temp.tipo_giornata=g.code
            where t.code='{$tipo_turno}'
            AND g.code='{$code_giornata}' AND a.guardia='S' AND a.code_uo='cardiologia'
            order by g.code, t.code, coeff_guardia, coalesce(count, 0), coalesce(max, '2000-01-01'), random()";
    $rs = $db->Esegui($sql);
    $candidati = $rs->GetArray();

    $first = true;
    echo "<table border='1' style='font-size:0.9em;'>";
    foreach($candidati as $i) {
        if ($first) {
            echo "<tr>";
            foreach($i as $k => $j) {
                echo "<th>{$k}</th>"; 
            }
            echo "</tr>"; 
            $first = false;
        }
            
        
        echo "<tr>";
        
        foreach($i as $j) {
            echo "<td>{$j}</td>"; 
        }
        
        echo "</tr>"; 
    }
    echo "</table>";

});


/***********************************************************************************************
* TEST  
***********************************************************************************************/
$klein->respond('POST', '/genera/turni/cardiologia/specializzandi', function ($request, $response, $service) {
    $service->render("genera_turni_cardiologia_specializzandi.php");
});



/***********************************************************************************************
* STAMPE
***********************************************************************************************/
$klein->respond('GET', '/stampe/guardie', function ($request, $response, $service) {
    GLOBAL $session, $stampa;
    error_log("GET /stampe/guardie");
    $session->assertLogin();
    $stampa = 1;
    $service->render("progetta_guardie.php");
});

/***********************************************************************************************
* TEST  
***********************************************************************************************/
$klein->respond('GET', '/test/mail', function ($request, $response, $service) {
    $service->render("test_mail.php");
});
$klein->respond('GET', '/ut/nodo', function ($request, $response, $service) {
    #$service->render("ut/nodo.test.php");
});



$klein->dispatch();
error_log("FINE");
?>
