<?php
GLOBAL $session, $anagrafiche, $stampa, $tipi_turno;

$db = getDB();
$smarty = $session->smarty();
$avanti = getVar("GET", "avanti", 0);
$indietro = getVar("GET", "indietro", 0);
#$stampa = getVar("GET", "stampa", 0);

$data_inizio = getVar("GET", "inizio");
$data_fine = getVar("GET", "fine");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = '2019-06-03';

if (strlen($data_fine) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_fine']))
    $data_fine = $_SESSION['PLANNING_data_fine'];
else
    $data_fine = '2019-06-02';

$data_inizio = '2020-10-01'; 
$data_fine = '2021-02-01'; 
    
$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a')) + 1;

$_SESSION['PLANNING_data_inizio'] = $data_inizio;
$_SESSION['PLANNING_data_fine'] = $data_fine;

$obj_calendario = Calendario::getInstance();
$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();
#Calendario::save();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('B');
$obj_planning->setGiorni($giorni_planning);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
$obj_planning->setTipiTurnoGuardie($tipi_turno);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();
Planning::save();


$calendario = $obj_calendario->getCalendario();


#-------------------------------------------------------------------------------
# TURNI DOPPI
#-------------------------------------------------------------------------------
$problems = [];
if ($stampa == 0) {
    $sql = "select data, code_anagrafica, count(*) as c
            from turni
            where data between '{$data_inizio}' and '{$data_fine}'
            and code_anagrafica not in ('GIA', 'BAL', 'VIS', 'ABB')
            and tipo_turno<>'CARDIO_MAT_INT'
            and tipo_turno<>'DISP'
            group by  data, code_anagrafica
            having count(*)>1";
    $rs = $db->Esegui($sql);
    while(!$rs->EOF) {
        $data = $rs->Fields("data");
        $problems[$data]["warnings"] = true;
        $rs->MoveNext();
    }
    
    # Turni doppi ma con R, I, C, F
    $sql = "select t.data, t.code_anagrafica, tipo_turno, COALESCE(turno, etichetta, tipo_turno) as turno
            from turni t
            left join tipo_turni_guardia tg ON tg.code=t.tipo_turno
            left join destinazioni td ON td.code=t.tipo_turno
            join (

                select code_anagrafica, data
                from turni
                where data between '{$data_inizio}' and '{$data_fine}'
                and code_anagrafica not in ('GIA', 'BAL', 'VIS', 'ABB')
                and tipo_turno<>'CARDIO_MAT_INT'
                and tipo_turno<>'DISP'
                group by  data, code_anagrafica
                having count(*)>1

            ) as src ON src.data=t.data and src.code_anagrafica=t.code_anagrafica

            where t.data between '{$data_inizio}' and '{$data_fine}'
            and t.code_anagrafica not in ('GIA', 'BAL', 'VIS', 'ABB')
            ORDER BY t.data, t.code_anagrafica";
    $rs = $db->Esegui($sql);
    while(!$rs->EOF) {
        $data = $rs->Fields("data");
        $tipo_turno = $rs->Fields("tipo_turno");
        if ($tipo_turno == 'I' || $tipo_turno == 'F' || $tipo_turno == 'C' || $tipo_turno == 'R')
            $problems[$data]["errors"] = true;
        $rs->MoveNext();
    }
}



#-------------------------------------------------------------------------------
# MEDICI DISPONIBILI
#-------------------------------------------------------------------------------
$disponibili = array();
$indisponibili = array();
$inferie = array();
$incongresso = array();
$inriposo = array();
$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    #if ($giorno['festa'])
    #    continue;
    foreach($anagrafiche as $code => $anag) {
        
        if (!isset($turni[$code][$data])) {
            if ($giorno['festa'] == 0)
                $disponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["DISP"])) {
            if ($giorno['festa'] == 0)
                $disponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["I"])) {
            $indisponibili[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["R"])) {
            $inriposo[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["F"])) {
            $inferie[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        elseif (isset($turni[$code][$data]["C"])) {
            $incongresso[$data][$code] = $anag;
            #echo " e' disponibile";
        }
        /*else {
            echo " NON e' disponibile";
            print_r($turni[$code][$data]);
        }
        echo "\r\n";*/
    }
}
# Memorizzo i disponibili per futuri usi:
$_SESSION["MEDICI_DISPONIBILI"] = $disponibili;
// $guardie = $obj_planning->getGuardie();
// print_r($guardie);
// exit();

#-------------------------------------------------------------------------------
# ASSEGNAZIONI
#-------------------------------------------------------------------------------
if ($stampa == 0) {
    $smarty->assign("calendario", $calendario);
    $smarty->assign("guardie", $obj_planning->getGuardie());
    $smarty->assign("pianolavoro", $obj_planning->getPianoLavoro());
    $smarty->assign("avvisi", $obj_planning->getAvvisi());
    $smarty->assign("giorni", $giorni_planning);
    $smarty->assign("disponibili", $disponibili);
    $smarty->assign("indisponibili", $indisponibili);
    $smarty->assign("inferie", $inferie);
    $smarty->assign("incongresso", $incongresso);
    $smarty->assign("inriposo", $inriposo);
    $smarty->assign("problems", $problems);
    $smarty->display('progetta_guardie.tpl');
}
elseif ($stampa == 1) {
    $guardie = $obj_planning->getGuardie();
    require_once("stampa_planning.php");
}
elseif ($stampa == 2) {
    $piano = $obj_planning->getPianoLavoro();
    require_once("stampa_piano_lavoro.php");
}
elseif ($stampa == 3) {
    $piano = $obj_planning->getPianoLavoro();
    require_once("stampa_piano_lavoro_ferie.php");
}
elseif ($stampa == 4) {
    $piano = $obj_planning->getPianoLavoro();
    require_once("stampa_piano_lavoro_emo.php");
}
elseif ($stampa == 5) {
    $piano = $obj_planning->getPianoLavoro();
    require_once("stampa_piano_lavoro_ferie_emo.php");
}
?>
