<?php
require("include/clsTCPDF.inc.php");

class iPDF extends PDF
{
	var $Title;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Ln(15);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(15);
	}
	
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}

}
//***************************************************************

$cell_width = 9;
    
# Calendario2[ codice mese] [ elenco giorni ]
$calendario2 = array();

foreach($calendario as $key => $g) {
    $data = $g["data"];
    $mese = substr($data, 5, 2);
    $calendario2[$mese][$key] = $g;
}

$pdf = new iPDF('L');

foreach($anagrafiche as $code_anagrafica => $anag) {
    
    $pdf->Title = "PLANNING FERIE {$anag['nome']} {$anag['cognome']}";
    $pdf->SetMargins(5, 35);
    $pdf->AddPage();

    //-----------------------------------------------------------------------
    // PAGINA
    //-----------------------------------------------------------------------
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFillColor(224,235,255);
    $pdf->SetFont('','',8);
    
    //-----------------------------------------------------------------------
    // MESI
    //-----------------------------------------------------------------------
    foreach($calendario2 as $calendario) {

        //-----------------------------------------------------------------------
        // INTESTAZIONE CALENDARIO
        //-----------------------------------------------------------------------
        $first = true;
        foreach($calendario as $key => $g) {
            if ($first) {
                $first = false;
                
                $pdf->SetFont('','',8);
                
                # Calendario
                $pdf->SetTextColorHex("#000");
                $pdf->SetFillColorHex("#FF0");
                $pdf->Cell(10, 4, "{$g['anno']}", 1, 0, 'C', 1);
            }
            # Calendario
            $data = $g["data"];
            
            $feriale = false;
            if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
            elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
            elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
            elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
            else { $bgcolor='#FFF'; $fcolor = '#000'; $feriale = true; }
                    
            
            $pdf->SetFont('','',6);
            $pdf->SetTextColorHex($fcolor);
            $pdf->SetFillColorHex($bgcolor);
            $pdf->Cell($cell_width, 5, "{$g['giorno']}", 1, 0, 'C', 1);
        }
        $pdf->Ln();
    
        $first = true;
        foreach($calendario as $key => $g) {
            if ($first) {
                $first = false;
                
                $pdf->SetFont('','',8);
                
                # Calendario
                $pdf->SetTextColorHex("#000");
                $pdf->SetFillColorHex("#FF0");
                $pdf->Cell(10, 4, "{$g['mese']}", 1, 0, 'C', 1);
            }
            $data = $g["data"];
            
            $feriale = false;
            if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
            elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
            elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
            elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
            else { $bgcolor='#FFF'; $fcolor = '#000'; $feriale = true; }
                    
            
            $pdf->SetFont('','',6);
            $pdf->SetTextColorHex($fcolor);
            $pdf->SetFillColorHex($bgcolor);
            
            # Calendario
            $pdf->Cell($cell_width, 5, "{$g['gsettimana']}", 1, 0, 'C', 1);
        }
        $pdf->Ln();
    
        //-----------------------------------------------------------------------
        // TURNI DEL MESE
        //-----------------------------------------------------------------------
        $first = true;
        foreach($calendario as $key => $g) {
            if ($first) {
                $first = false;
                $pdf->Cell(10, 4, "", 0, 0, 'C', 0);
            }
            $data = $g["data"];
            
            $feriale = false;
            if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
            elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
            elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
            elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
            else { $bgcolor='#FFF'; $fcolor = '#000'; $feriale = true; }
            
            $pdf->SetFont('','',10);
            $pdf->SetTextColorHex($fcolor);
            $pdf->SetFillColorHex($bgcolor);
                
                #-------------------------------------------------------------------------
                $t = $turni[$code_anagrafica][$data];
                #-------------------------------------------------------------------------
                $tt = "";
                foreach($t as $item) {
                    $etichetta_turno = "";
                    if (strlen($tipi_turno[$item["tipo_turno"]])) {
                        $etichetta_turno = $tipi_turno[$item["tipo_turno"]];
                        // $bgcolor='#555'; #8fadcc';
                        // $fcolor='#FFF';
                        // $pdf->SetFont('','B', 8);
                    }
                    elseif (strlen($destinazioni[$item["tipo_turno"]]["etichetta"]))
                        $etichetta_turno = $destinazioni[$item["tipo_turno"]]["etichetta"];
                    else
                        $etichetta_turno = $item["tipo_turno"];
                        
                    if ($etichetta_turno == "DISP")
                        $etichetta_turno = "";
                        
                    if (in_array($item["tipo_turno"], array('F', 'I', 'C'))) {
                        $bgcolor='#FA8';
                    } 
                    else {
                        $etichetta_turno = ""; # Qui mostro SOLO indisponibilit
                    }
                    
                    $tt .= $etichetta_turno;#." / ";
                    
                }
                #$tt = substr($tt, 0, -3);
                ### TEMP
                #if (!in_array($item["tipo_turno"], array('F', 'I', 'C')))
                #    $tt = "";
                ### /TEMP
                
                $pdf->SetTextColorHex($fcolor);
                $pdf->SetFillColorHex($bgcolor);
                $pdf->MultiCell($cell_width, 5, $tt, 1, 'C', 1, 0, 
                    $x = '',
                    $y = '',
                    $reseth = false,
                    $stretch = 3,
                    $ishtml = false,
                    $autopadding = true,
                    $maxh = 5,
                    $valign = 'T',
                    $fitcell = true );

            
            
        }
        $pdf->Ln();
        $pdf->Ln(10);
    }
}

$pdf->Output("planning-ferie.pdf", 'D');
?>
