<?php
require("include/clsTCPDF.inc.php");

class iPDF extends PDF
{
	var $Title;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(5);
	}
	
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}

}
//***************************************************************
$cell_width = 6;
$COMPLETO = false;
$EMO = true;

$pdf = new iPDF('P');
$pdf->Title = "PLANNING PIANO LAVORO EMODINAMICA";
$pdf->SetMargins(5, 5);
$pdf->AddPage();

//-----------------------------------------------------------------------
// PAGINA
//-----------------------------------------------------------------------
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(224,235,255);

$dimensione_postazione = 11;
if ($COMPLETO)
    $dimensione_postazione = 8;
if ($COMPLETO == false && $EMO == false)
    $dimensione_postazione = 15;

//-----------------------------------------------------------------------
// INTESTAZIONE PLANNING
//-----------------------------------------------------------------------
$first = true;
foreach($calendario as $key => $g) {
    if ($first || $g['giorno'] == 1) {
        $first = false;
        
        # Calendario
        $pdf->SetFont('','',8);
        $pdf->SetTextColorHex("#000");
        $pdf->SetFillColorHex("#FF0");
        $pdf->Cell(15, 6, "{$g['mese']} {$g['anno']}", 1, 0, 'C', 1);
        
        # Turni
        $pdf->SetFont('','',6);
        $pdf->SetTextColorHex("#FFF");
        $pdf->SetFillColorHex("#333");
        foreach($destinazioni as $code => $dest) {
            if (!in_array($code, array('EMOREP', 'EMO1', 'EMO2', 'EMO3')))
                continue;
            if ($EMO == false) {
                if (in_array($code, array('EMOREP', 'EMO1', 'EMO2', 'EMO3')))
                    continue;
                #$pdf->Cell(8, 4, $dest['etichetta'], 1, 0, 'C', 1);
            }
            $pdf->MultiCell($dimensione_postazione, 6, $dest['etichetta'], 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 1,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
        }
        #Disp, riposo, indisp, ferie e congressi
        $pdf->SetFont('','B');
        if ($COMPLETO) {
            $pdf->SetTextColorHex("#FFF");
            $pdf->SetFillColorHex("#060");
            $pdf->Cell(20, 4, "DISP", 1, 0, 'C', 1);
        }
        $pdf->SetTextColorHex("#FFF");
        $pdf->SetFillColorHex("#C00");
        if ($COMPLETO) {
            $pdf->Cell(15, 4, "RIPOSO", 1, 0, 'C', 1);
            $pdf->Cell(15, 4, "INDISP", 1, 0, 'C', 1);
        }
        if ($COMPLETO)
            $pdf->Cell(25, 4, "FERIE", 1, 0, 'C', 1);
        if ($COMPLETO)
            $pdf->Cell(10, 4, "CONGR", 1, 0, 'C', 1);
        $pdf->Ln();
    }
    
    if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
    elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
    elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
    elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
    else {$bgcolor='#FFF'; $fcolor = '#000'; }
            
    
    $pdf->SetFont('','',8);
    $pdf->SetTextColorHex($fcolor);
    $pdf->SetFillColorHex($bgcolor);
        

    # Calendario
    $pdf->Cell(15, 4, "{$g['gsettimana']} {$g['giorno']}", 1, 0, 'C', 1);

    # Piano lavoro
    foreach($destinazioni as $code => $dest) {
        if (!in_array($code, array('EMOREP', 'EMO1', 'EMO2', 'EMO3')))
            continue;
        if ($EMO == false) {
            if (in_array($code, array('EMOREP', 'EMO1', 'EMO2', 'EMO3')))
                continue;
        }
        if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
        elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
        elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
        elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
        else {$bgcolor='#EEE'; $fcolor = '#000'; }    
        $pdf->SetTextColorHex($fcolor);
        $pdf->SetFillColorHex($bgcolor);
    
        $code_anagrafica = $piano[$g['data']][$code]["code_anagrafica"];
        #$color = $anagrafiche[$code_anagrafica]['colore'];
        #$background = $anagrafiche[$code_anagrafica]['background'];
        
        if (strlen($code_anagrafica)==0 && $code=='EMO1' && $g["gsettimana"] == "Mar") {
            $code_anagrafica = "TAVI";
            $color = "#000";
            $background = "#FFF";
        }
        
        $pdf->SetFont('','',7);
        #$pdf->SetTextColorHex($color);
        #$pdf->SetFillColorHex($background);
        $pdf->Cell($dimensione_postazione, 4, $code_anagrafica, 1, 0, 'C', 1);
    }
    #$pdf->Ln();
    #continue;
    
    $pdf->SetFont('','',4);
    $pdf->SetTextColorHex("#000");
    if ($g['festa'])
        $pdf->SetFillColorHex("#DDD");
    else
        $pdf->SetFillColorHex("#FFF");
        
    if ($COMPLETO) {
        
        #Disponibili
        $tt = "";
        foreach($disponibili[$g['data']] as $code => $item) {
            if ($code != "EMO" && $code != "ABB")
                $tt .= " {$code} ";
        }
        $pdf->MultiCell(20, 4, $tt, 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 1,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
                
        $pdf->SetTextColorHex("#000");
        if ($g['festa'])
            $pdf->SetFillColorHex("#CCC");
        else
            $pdf->SetFillColorHex("#EEE");

        #A riposo
        $tt = "";
        foreach($inriposo[$g['data']] as $code => $item) {
            $tt .= " {$code} ";
        }
        $pdf->MultiCell(15, 4, $tt, 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 3,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
                
        #Indisponibili
        $tt = "";
        foreach($indisponibili[$g['data']] as $code => $item) {
            $tt .= " {$code} ";
        }
        $pdf->MultiCell(15, 4, $tt, 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 3,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
    }
    if ($COMPLETO) {
        #In ferie
        $tt = "";
        foreach($inferie[$g['data']] as $code => $item) {
            $tt .= " {$code} ";
        }
        $pdf->MultiCell(25, 4, $tt, 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 3,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
    }      
    if ($COMPLETO) {
        #A congresso
        $tt = "";
        foreach($incongresso[$g['data']] as $code => $item) {
            $tt .= " {$code} ";
        }
        $pdf->MultiCell(10, 4, $tt, 1, 'C', 1, 0, 
                $x = '',
                $y = '',
                $reseth = false,
                $stretch = 3,
                $ishtml = false,
                $autopadding = true,
                $maxh = 10,
                $valign = 'T',
                $fitcell = true );
                
        #Disp, indisp, ferie e congressi
        /*
        $disponibili = array();
        $indisponibili = array();
        $inferie = array();
        $incongresso = array();
        $inriposo = array();*/
    }
    $pdf->Ln();
}


$pdf->Output("planning-piano-lavoro.pdf", 'D');
?>
