<?php
require("include/clsTCPDF.inc.php");

class iPDF extends PDF
{
	var $Title;
	
	function Header() {
			//Arial bold 15
			//PDF::Header();
			
			//Colors of frame, background and text
			$this->SetDrawColor(0, 0, 0);
			$this->SetFillColor(0, 0, 0);
			$this->SetLineWidth(0);
			
			$this->SetFont('','B',12);
			$this->SetTextColor(33, 66, 99);
			$this->Cell(0, 5 ,$this->Title, 0, 1, 'C', 0);
			$this->Ln(5);
	}
	
	function SetTextColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetTextColor($rgb[0], $rgb[1], $rgb[2]);
	}
    
	function SetFillColorHex($hex) {
	    if (strlen($hex) == 0)
	        return;
	    $rgb = hex2rgb($hex);
        $this->SetFillColor($rgb[0], $rgb[1], $rgb[2]);
	}

}
//***************************************************************

$cell_width = 10;
if ($EMO == false)
    $cell_width = 11.8;
    
$pdf = new iPDF('L');
$pdf->Title = "PLANNING TURNI";
$pdf->SetMargins(5, 5);
$pdf->AddPage();

//-----------------------------------------------------------------------
// PAGINA
//-----------------------------------------------------------------------
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(224,235,255);
$pdf->SetFont('','',8);

//-----------------------------------------------------------------------
// INTESTAZIONE PLANNING
//-----------------------------------------------------------------------
$first = true;
foreach($calendario as $key => $g) {
    if ($first || $g['giorno'] == 1) {
        $first = false;
        
        $pdf->SetFont('','',8);
        
        # Calendario
        $pdf->SetTextColorHex("#000");
        $pdf->SetFillColorHex("#FF0");
        $pdf->Cell(15, 4, "{$g['mese']} {$g['anno']}", 1, 0, 'C', 1);
        
        # Anagrafiche
        $pdf->SetTextColorHex("#FFF");
        $pdf->SetFillColorHex("#333");
        foreach($anagrafiche as $code_anagrafica => $anag) {
            if ($EMO == false) {
                if ($code_anagrafica == "ABB")
                    continue;
                if ($code_anagrafica == "BAL")
                        continue;
                if ($code_anagrafica == "GIA")
                        continue;
                if ($code_anagrafica == "VIS")
                        continue;
            }
        
            $color = $anag['colore'];
            $background = $anag['background'];
            
            $pdf->SetTextColorHex($color);
            $pdf->SetFillColorHex($background);
            $pdf->Cell($cell_width, 4, $anag['sigla'], 1, 0, 'C', 1);
        }
        $pdf->Ln();
    }
    $data = $g["data"];
    
    $feriale = false;
    if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
    elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
    elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
    elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
    else { $bgcolor='#FFF'; $fcolor = '#000'; $feriale = true; }
    
    $pdf->SetFont('','',6);
    $pdf->SetTextColorHex($fcolor);
    $pdf->SetFillColorHex($bgcolor);
        

    # Calendario
    $pdf->Cell(15, 5, "{$g['gsettimana']} {$g['giorno']}", 1, 0, 'C', 1);
    
    # Turni anagrafiche
    foreach($anagrafiche as $code_anagrafica => $anag) {
        if ($EMO == false) {
            if ($code_anagrafica == "ABB")
                    continue;
            if ($code_anagrafica == "BAL")
                    continue;
            if ($code_anagrafica == "GIA")
                    continue;
            if ($code_anagrafica == "VIS")
                    continue;
        }
        $pdf->SetFont('','',6);
        if ($g['festivita']) { $bgcolor='#ccd9ff'; $fcolor = '#008'; }
        elseif ($g['prefestivita']) { $bgcolor='#e5ecff'; $fcolor = '#008'; }
        elseif ($g['sabato']) { $bgcolor='#ffe5f2'; $fcolor = '#800'; }
        elseif ($g['domenica']) { $bgcolor='#ffcce6'; $fcolor = '#800'; }
        else {$bgcolor='#DDD'; $fcolor = '#000'; }    
        
        $t = $turni[$code_anagrafica][$data];
        $tt = "";
        foreach($t as $item) {
            $etichetta_turno = "";
            if (strlen($tipi_turno[$item["tipo_turno"]])) {
                $etichetta_turno = $tipi_turno[$item["tipo_turno"]];
                $bgcolor='#555'; #8fadcc';
                $fcolor='#FFF';
                $pdf->SetFont('','B', 5);
            }
            elseif (strlen($destinazioni[$item["tipo_turno"]]["etichetta"]))
                $etichetta_turno = $destinazioni[$item["tipo_turno"]]["etichetta"];
            else
                $etichetta_turno = $item["tipo_turno"];
                
            if ($etichetta_turno == "DISP")
                $etichetta_turno = "";
                
            $tt .= $etichetta_turno." / ";
            if (in_array($item["tipo_turno"], array('F', 'I', 'C'))) {
                $bgcolor='#FA8';
            }
            
        }
        $tt = substr($tt, 0, -3);
        ### TEMP
        #if (!in_array($item["tipo_turno"], array('F', 'I', 'C')))
        #    $tt = "";
        ### /TEMP
        
        $pdf->SetTextColorHex($fcolor);
        $pdf->SetFillColorHex($bgcolor);
        $pdf->MultiCell($cell_width, 5, $tt, 1, 'C', 1, 0, 
            $x = '',
		  	$y = '',
		  	$reseth = false,
		  	$stretch = 3,
		  	$ishtml = false,
		  	$autopadding = true,
		  	$maxh = 5,
		  	$valign = 'T',
		  	$fitcell = true );
    }
    
    $pdf->Ln();
}


$pdf->Output("planning-turni.pdf", 'D');
?>
