{extends file="template-modal.tpl"}
{block name="content"}

<script>
var data='{$data}';
var tipo_turno='{$tipo_turno}';
var code_anagrafica='{$code_anagrafica}';
var dialog_ricevuta = false;

$(document).ready(function BindPlanningEvents() {
    $("#btn-log1").click(function(evt) {
        mostra_log(data, tipo_turno);
    });
    $("#btn-candidati").click(function(evt) {
        mostra_candidati(data, tipo_turno);
    });
    $('#form_cambia_turno').submit(function(event){
    
        event.preventDefault();
        console.log("form submit: "+"/turni/"+data+"/"+tipo_turno+"/"+code_anagrafica);
        
        var url = "/turni/"+data+"/"+tipo_turno;
        if (code_anagrafica.length)
            url = url + "/" + code_anagrafica;
        
        //return;
        $.ajax({
            type: "POST",
            url: url,
            data: $('#form_cambia_turno').serialize(),
            success: function () {
                console.log("success");
            }
        })
        .done(function( content ) {
            console.log(content);
            //return false;
            if (content == 'OK') {
                location.reload(); 
            }
            else if (content == 'KO') {
                var msg = JSON.parse('{ "description":"Errore non specificato." }');
                ShowMessage(msg, false);
            }
            else {
                alert(content);
                var msg = JSON.parse(content);
                ShowMessage(msg, false, function() { 
                    //window.location = "{$ROOT_URL}{$APP.url}/wizard/{$wizard_code}/list";
                });
            }
        });   
        
    });
});

function mostra_log(data) {
    var url = "/log/guardie/"+data+"/"+tipo_turno;
    //ShowModalPage(url);
    $('#modal_log .content').load(url);
    $('#modal_log')
        .modal({
            inverted: false,
            allowMultiple: true,
            closable  : false,
            //onApprove : function() { $("#frmOggetto").submit() }
        })
        .modal('show');
            
}

function mostra_candidati(data) {
    var url = "/log/candidati/"+data+"/"+tipo_turno;
    //ShowModalPage(url);
    $('#modal_log .content').load(url);
    $('#modal_log')
        .modal({
            inverted: false,
            allowMultiple: true,
            closable  : false,
            //onApprove : function() { $("#frmOggetto").submit() }
        })
        .modal('show');
            
}

//--------------------------------------------------------------------------------------
// CAMBIA TURNO
/*function CambiaTurno() {
    require(["dojo/dom", "app/dialog_oggetto"], function(dom, dialog) {
        var xhrArgs = {
            form: dom.byId("form_cambia_turno"),
            handleAs: "text",
            load: function(data){
                if (data == '1') {
                    dialog.close();
                    ReloadProgetta();
                }
                else
                    dom.byId("response").innerHTML = data;
            },
            error: function(error){
                // We'll 404 in the demo, but that's okay.  We don't have a 'postIt' service on the
                // docs server.
                dom.byId("response").innerHTML = "Errore";
            }
        }
        // Call the asynchronous xhrPost
        dom.byId("response").innerHTML = "Form being sent..."
        var deferred = dojo.xhrPost(xhrArgs);
    });
}*/
</script>
<style>

</style>

<div>
{if $tipi_turno_ext[$tipo_turno]|default:false == false}
    <button id="btn-log1" class="ui button">Log</button>
{/if}
{if $tipi_turno[$tipo_turno]|default:false != false}
    <button id="btn-candidati" class="ui button">Candidati</button>
{/if}
</div>

{if $destinazioni[$tipo_turno].etichetta|default:false}{assign var="turno" value=$destinazioni[$tipo_turno].etichetta}
{elseif $tipi_turno[$tipo_turno]|default:false}{assign var="turno" value=$tipi_turno[$tipo_turno]}
{elseif $tipi_turno_ext[$tipo_turno]|default:false}{assign var="turno" value=$tipi_turno_ext[$tipo_turno]}
{else}{assign var="turno" value=$tipo_turno}{/if}

<h3>Turno <span style="color:#C00;">{$turno}</span> del <span style="color:#C00;">{$data|date_format:"%d/%m/%Y"}</span></h3>
Attuale: <span style="color:orange; font-weight:bold; font-size:1.5em;" class="">{$code_anagrafica|default:"nessuno"}</span><br>

{if $stato == 'P'}
    <h3 style="color:red;">Stato PUBBLICATO, impossibile modificare!</h3>
{else}
<form id="form_cambia_turno" name="form_cambia_turno" method="POST">
    <input type="hidden" name="ok_cambia_turno" value="1" />
    <input type="hidden" name="tipo_turno" value="{$tipo_turno}" />
    <input type="hidden" name="data" value="{$data}" />
    <input type="hidden" name="anag" value="{$code_anagrafica}" />

    {if $tipi_turno_ext[$tipo_turno]|default:false == false}
    <p>
    

    Cambia con: <select name="cambia_con">
        <option value="LASCIA">lascia cos&igrave;</option> 
    {if $code_anagrafica|default:"nessuno" != "nessuno"}
        <option value="VUOTO">chiudi postazione</option> 
    {else}
    {foreach item="disp" key="c" from=$disponibili}
        <option value="{$c}">{$c}</option> 
    {/foreach}
    {/if}
    </select>
    </p>
    <p>
    {if $code_anagrafica|default:"nessuno" == "nessuno"}
    Doppio turno: <select name="doppio_con">
        <option value="NODOPPIO">nessun doppio turno</option> 
    {foreach item="disp" key="c" from=$lavoratori}
        <option value="{$c}">{$c}</option> 
    {/foreach}
    </select>
    {/if}
    </p>

    {else}
        
    <p>
    Cambia con: <select name="cambia_con">
        <option value="LASCIA">lascia cos&igrave;</option> 
    {foreach item="item" key="c" from=$tipi_turno_ext}
        <option value="{$c}">{$item}</option> 
    {/foreach}
    </select>
    </p>  
    {/if}
    
    {if $code_anagrafica|count_characters > 0}
    <p>
    Inverti con: <select name="inverti_con">
        <option value="NONINVERTIRE">non invertire</option> 
    {foreach item="item" key="c" from=$lavoratori_piano}
        <option value="{$c}">{$c}</option> 
    {/foreach}
    </select>
    </p>  
    {/if}
    <button type="submit" class="ui teal button">Salva</button>
</form>
{/if}

<div id="response"></div>


<div class="ui large modal" id="modal_log">
    <div class="actions">
        <div class="ui teal cancel button">
            <i class="remove icon"></i> Chiudi
        </div>
    </div>
    <div class="scrolling content"></div>
</div>


{/block}
