<html>
<head>
{block name="html_head"}
    <!-- Standard Meta -->
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">

    <!-- Site Properties -->
    <title>San Martino Guardie</title>
    <link rel="stylesheet" type="text/css" href="/static/components/reset.css">

    <link rel="stylesheet" type="text/css" href="/static/semantic.min.css">
    <link rel="stylesheet" type="text/css" href="/static/semantic-calendar.min.css">
    
    <link rel="stylesheet" type="text/css" href="/static/style.css" media="screen"> 
    <link rel="stylesheet" type="text/css" href="/static/colori.css" media="screen">
    
    <link href="https://fonts.googleapis.com/css?family=Montserrat|Open+Sans|Yanone+Kaffeesatz:200" rel="stylesheet"> 
    
    
    <script src="/static/assets/library/jquery.min.js"></script>

    <script src="/static/semantic.min.js"></script>
    <script src="/static/semantic-calendar.min.js"></script>
    
    <script>
    function ShowMessage(msg, closeable=true, funcOK=function() {}, funcKO=function() {}) {
        // TODO Check msg format
        $('#modal_message .content').html("<p>"+msg.description+"</p>");
        //$('#modal_message #message_title').html(msg.title);
        if (msg.level == "WARNING") {
            $('#modal_message_si_button').css({ 'display':'initial' });
            $('#modal_message_no_button').css({ 'display':'initial' });
            $('#modal_message_ok_button').css({ 'display':'none' });
            $('#modal_message .content').append("<p>Vuoi proseguire?</p>");
        }
        else {
            $('#modal_message_si_button').css({ 'display':'none' });
            $('#modal_message_no_button').css({ 'display':'none' });
            $('#modal_message_ok_button').css({ 'display':'initial' });
        }
        $('#modal_message')
            .modal({
                inverted: false,
                closable  : closeable,
                onApprove : funcOK,
                onDeny : funcKO
              })
            .modal('show');
    }
    function ShowModalPage(url, closeable=false, funcOK=function() {}, funcKO=function() {}) {
        
        $('#modal_form .content').load(url);
        $('#modal_form')
            .modal({
                inverted: false,
                allowMultiple: true,
                closable  : false,
                //onApprove : function() { $("#frmOggetto").submit() }
            })
            .modal('show');
    }
    
    $(document).ready(function() {
        $('select.dropdown').dropdown();
        $('.ui.dropdown').dropdown();
        $('.ui.calendar').calendar({ 
            type: 'date',
            firstDayOfWeek: 1,
            text: {
                days: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
                months: ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'],
                monthsShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu', 'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
                today: 'Oggi',
                now: 'Ora',
                am: 'AM',
                pm: 'PM'
            },
            monthFirst: false,
            formatter: {
                date: function (date, settings) {
                    if (!date) return '';
                    var day = date.getDate();
                    var month = date.getMonth() + 1;
                    var year = date.getFullYear();
                    return day + '/' + month + '/' + year;
                }
            }
        });
        $('.ui.calendar.yearfirst').calendar({ 
            type: 'date',
            startMode: 'year',
            firstDayOfWeek: 1,
            text: {
                days: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
                months: ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'],
                monthsShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu', 'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
                today: 'Oggi',
                now: 'Ora',
                am: 'AM',
                pm: 'PM'
            },
            monthFirst: false,
            formatter: {
                date: function (date, settings) {
                    if (!date) return '';
                    var day = date.getDate();
                    var month = date.getMonth() + 1;
                    var year = date.getFullYear();
                    return day + '/' + month + '/' + year;
                }
            }
        });
        
        
        
    
    
    
    });
    </script>
    
    
    <style>
    .bold { font-weight: bold; }
    .dx { text-align: right; }
    .bianco { color: white; }
    .verde { color: green; }
    .rosso { color: #C00; }
    .blu { color: #369; }
    </style>
    {block name="html_head_default_style"}
    {/block}
  
    {block name="html_head_extra"}
    {/block}
{/block}
</head>
<body>
{block name="html_body"}
{/block}


<div class="ui modal" id="modal_form">
    <div class="actions">
        <div class="ui teal cancel button">
            <i class="remove icon"></i> Chiudi
        </div>
    </div>
    <div class="scrolling content"></div>
</div>

<div class="ui modal" id="modal_message">
    <div class="ui icon header">
        
        <span id="message_title"><i class="announcement icon"></i> San Martino Guardie</span>
    </div>
    <div class="content">Messaggio</div>
    <div class="actions">
        <div class="ui orange ok inverted button" id="modal_message_ok_button">
            <i class="checkmark icon"></i> OK
        </div>
        <div class="ui green ok inverted button" id="modal_message_si_button" style="display: none;">
            <i class="checkmark icon"></i> SI
        </div>
        <div class="ui red cancel inverted button" id="modal_message_no_button" style="display: none;">
            <i class="remove icon"></i> NO
        </div>
    </div>
</div>


</body>
</html> 