{extends file="init.tpl"}


{block name="html_head_extra"}
<style type="text/css">
    body {
      background-color: #DADADA;
    }
    body > .grid {
      height: 100%;
    }
    .image {
      margin-top: -100px;
    }
    .column {
      max-width: 450px;
    }
</style>
  <script>
  $(document)
    .ready(function() {
      $('.ui.form')
        .form({
          fields: {
            username: {
              identifier  : 'username',
              rules: [
                {
                  type   : 'empty',
                  prompt : "Inserisci la tua username"
                }
              ]
            },
            password: {
              identifier  : 'password',
              rules: [
                {
                  type   : 'empty',
                  prompt : 'Inserisci la password'
                }/*,
                {
                  type   : 'length[5]',
                  prompt : 'La password deve essere di almeno 5 caratteri'
                }*/
              ]
            }
          },
        onSuccess: function(event, fields) {
            event.preventDefault();
            $.ajax({
                type: 'post',
                url: '/login',
                data: $('form').serialize(),
                success: function () {
                    //"ok" label on success.
                    //$('#successLabel').css("display", "block");
                    console.log("success");
                }
            })
            .done(function( data ) {
                console.log(data);
                if (data == 'OK') {
                    window.location = "/";
                }
                else if (data == 'KO') {
                    $('.ui.error.message').html("Errore nel login");
                    $('.ui.form').addClass('error'); //response.msg
                }
                else {
                    var msg = JSON.parse(data);
                    if (msg['result']) {
                        window.location = msg['customs']['url'];
                    }
                    else
                        ShowMessage(msg, false);
                }
            });      
        }
        });

    
    });
  
 
  </script>
{/block}

{block name="html_body"}

<div class="ui middle aligned center aligned grid">
  <div class="column">
    <h2 class="ui teal image header">
      <div class="content">
        Accedi a San Martino Guardie
      </div>
    </h2>
    <form class="ui large form" method="POST">
      <div class="ui stacked segment">
        <div class="field">
          <div class="ui left icon input">
            <i class="user icon"></i>
            <input type="text" name="username" placeholder="Username">
          </div>
        </div>
        <div class="field">
          <div class="ui left icon input">
            <i class="lock icon"></i>
            <input type="password" name="password" placeholder="Password">
          </div>
        </div>
        <button type="button" id="btnLogin" class="ui fluid large teal submit button">Login</button>
      </div>

      <div class="ui error message">Login fallita!</div>

    </form>
  </div>
</div>
{/block}
