{extends file="init.tpl"}

{block name="html_head_default_style"}
    <style type="text/css">
    html,body {
        font-family: 'Open Sans', sans-serif !important;
        font-size: 12px;
    }
    #page {
        min-height:100%;
    }
    #page_header {
        border-bottom: 3px solid teal;
    }
    
    #page_content {
        /*font-size: 4px !important;*/
    }

    #page_footer {
        border-top: 0px solid teal;
    }
    
    .hidden.menu {
      display: none;
    }
/*
    .masthead.segment {
      padding: 1em 0em;
    }
    .masthead .logo.item img {
      margin-right: 1em;
    }
    .masthead .ui.menu .ui.button {
      margin-left: 0.5em;
    }
    
    .masthead h1.ui.header {
      margin-top: 3em;
      margin-bottom: 0em;
      font-size: 4em;
      font-weight: normal;
    }
    .masthead h2 {
      font-size: 1.7em;
      font-weight: normal;
    }

    .ui.vertical.stripe {
      padding: 8em 0em;
    }
    .ui.vertical.stripe h3 {
      font-size: 2em;
    }
    .ui.vertical.stripe .button + h3,
    .ui.vertical.stripe p + h3 {
      margin-top: 3em;
    }
    .ui.vertical.stripe .floated.image {
      clear: both;
    }
    .ui.vertical.stripe p {
      font-size: 1.33em;
    }
    .ui.vertical.stripe .horizontal.divider {
      margin: 3em 0em;
    }

    .quote.stripe.segment {
      padding: 0em;
    }
    .quote.stripe.segment .grid .column {
      padding-top: 5em;
      padding-bottom: 5em;
    }

    .footer.segment {
      padding: 5em 0em;
    }

    .secondary.menu .toc.item {
      display: none;
    } 
*/
    .secondary.menu a {
      color: white !important;
    }
   

    @media only screen and (max-width: 700px) {
      .ui.fixed.menu {
        display: none !important;
      }
      .secondary.menu .item,
      .secondary.menu .menu {
        display: none !important;
      }
      .secondary.menu .toc.item {
        display: block !important;
      }
      .secondary.menu .logo {
        display: none !important;
      }
      .masthead h1.ui.header {
        font-size: 2em;
        margin-top: 1.5em;
      }
      .masthead h2 {
        margin-top: 0.5em;
        font-size: 1.5em;
      }
      .ui.container {
        width: 100%;
      }
      
      
      
    }
  </style>
  <script>
  $(document).ready(function() {

      // fix menu when passed
      $('.masthead')
        .visibility({
          once: false,
          onBottomPassed: function() {
            $('.fixed.menu').transition('fade in');
          },
          onBottomPassedReverse: function() {
            $('.fixed.menu').transition('fade out');
          }
        });

      // create sidebar and attach to menu open
      $('.ui.sidebar').sidebar('attach events', '.toc.item');
    });
  </script>
    {/block}

{block name="html_head_extra"}

{/block}

{block name="html_body"}


<!-- Sidebar Menu -->
<div class="ui vertical inverted sidebar menu">
  <a class="active item" href="/">Home</a>
  <a class="item" href="/ferie">Ferie</a>
  {if $login}
  <a class="item" href="/logout">Esci</a>
  {else}
  <a class="item" href="/login">Accedi</a>
  {/if}
</div>


<!-- Page -->
<div id="page" class="pusher">
  {block name="page_superheader"}{/block}
    
  {block name="page_header"}
  <div id="page_header" class="ui">
      {block name="header"}
      <div class="ui vertical masthead center aligned segment  inverted grey">
        <div class="ui container">
          <div class="ui large secondary menu">
            <a class="toc item">
              <i class="sidebar icon"></i>
              San Martino Guardie
            </a>
            <a class="{if $REQUEST_URI == '/'}active{/if} item" href="/" style="color:white;">Home</a>
            <a class="{if $REQUEST_URI == '/ferie'}active{/if} item" href="/ferie">Ferie</a>
            
            <div class="ui teal buttons">
              <div class="ui button">Stampe</div>
              <div class="ui combo top right pointing dropdown icon button">
                <i class="dropdown icon"></i>
                <div class="menu">
                  <a class="item" href="/stampe/guardie"><i class="print icon"></i> Stampa guardie</a>
                  <a class="item" href="progetta_guardie.php?stampa=2"><i class="print icon"></i> Stampa piano di lavoro</a>
                  <a class="item" href="progetta_guardie.php?stampa=3"><i class="print icon"></i> Stampa piano di lavoro completo</a>
                  <a class="item" href="progetta_guardie.php?stampa=4"><i class="print icon"></i> Stampa piano di lavoro emo</a>
                  <a class="item" href="progetta_guardie.php?stampa=5"><i class="print icon"></i> Stampa piano di lavoro completo + emo</a>
                  <a class="item" href="turni.php?stampa=1"><i class="print icon"></i> Stampa turni</a>
                  <a class="item" href="turni.php?stampa=2"><i class="print icon"></i> Stampa turni + EMO</a>
                  <a class="item" href="turni.php?stampa=3"><i class="print icon"></i> Stampa ferie</a>
                  <a class="item" href="stampa_totali1.php"><i class="print icon"></i> Totalizzatore 1</a>
                  <a class="item" href="stampa_totali2.php"><i class="print icon"></i> Totalizzatore 2</a>
                </div>
              </div>
            </div>

            
    
    
    
    
    
    

            
            <div class="right item">
                {if $login}
                <a class="ui teal button" href="/logout">Esci</a>
                {else}
                <a class="ui teal button" href="/login">Accedi</a>
                {/if}
            </div>
          </div>
        </div>

        {block name="home_header"}
        {/block}
      </div>
      {/block}
  </div>
  {/block}
  
  <!-- Page Contents -->
  {block name="page_content"}
  <div id="page_content" class="ui">
      <div class="ui container" style="border:0px solid red;">
      {block name="content"}
      {/block}
      </div>
  </div>
  {/block}
  
  <!-- Page Footer -->
  {block name="page_footer"}
  <div id="page_footer" class="ui">
      
  </div>
  {/block}
</div>
<!--script type="text/javascript" src="https://cdn.jsdelivr.net/npm/cookie-bar/cookiebar-latest.min.js?theme=flying&tracking=1&thirdparty=1&scrolling=1&remember=30&privacyPage=%2Fcookie-policy"></script-->
{/block}
