{extends file="init.tpl"}

{block name="html_head_default_style"}
    <style type="text/css">
    #page {
        min-height:100%;
        background-color: #EEE;
    }
    #page_header {
    }
    #page_content {
    }
    #page_footer {
    }
    
    .hidden.menu {
      display: none;
    }
    
    .ui.inverted.segment.footer {
        background: #68674a;
    }

    .masthead.segment {
      padding: 1em 0em;
    }
    .masthead .logo.item img {
      margin-right: 1em;
    }
    .masthead .ui.menu .ui.button {
      margin-left: 0.5em;
    }
    .masthead h1.ui.header {
      margin-top: 3em;
      margin-bottom: 0em;
      font-size: 4em;
      font-weight: normal;
    }
    .masthead h2 {
      font-size: 1.7em;
      font-weight: normal;
    }

    .ui.vertical.stripe {
      padding: 8em 0em;
    }
    .ui.vertical.stripe h3 {
      font-size: 2em;
    }
    .ui.vertical.stripe .button + h3,
    .ui.vertical.stripe p + h3 {
      margin-top: 3em;
    }
    .ui.vertical.stripe .floated.image {
      clear: both;
    }
    .ui.vertical.stripe p {
      font-size: 1.33em;
    }
    .ui.vertical.stripe .horizontal.divider {
      margin: 3em 0em;
    }

    .quote.stripe.segment {
      padding: 0em;
    }
    .quote.stripe.segment .grid .column {
      padding-top: 5em;
      padding-bottom: 5em;
    }

    .footer.segment {
      padding: 5em 0em;
    }

    .secondary.pointing.menu .toc.item {
      display: none;
    }

    @media only screen and (max-width: 700px) {
      .ui.fixed.menu {
        display: none !important;
      }
      .secondary.pointing.menu .item,
      .secondary.pointing.menu .menu {
        display: none;
      }
      .secondary.pointing.menu .toc.item {
        display: block;
      }
      .masthead h1.ui.header {
        font-size: 2em;
        margin-top: 1.5em;
      }
      .masthead h2 {
        margin-top: 0.5em;
        font-size: 1.5em;
      }
      .ui.container {
        width: 100%;
      }
    }
  </style>
  <script>
  $(document).ready(function() {

      // fix menu when passed
      $('.masthead')
        .visibility({
          once: false,
          onBottomPassed: function() {
            $('.fixed.menu').transition('fade in');
          },
          onBottomPassedReverse: function() {
            $('.fixed.menu').transition('fade out');
          }
        });

      // create sidebar and attach to menu open
      $('.ui.sidebar').sidebar('attach events', '.toc.item');
    });
  </script>
    {/block}

{block name="html_head_extra"}

{/block}

{block name="html_body"}


<!-- Sidebar Menu -->
<div class="ui vertical inverted sidebar menu">
    <a class="active item" href="/">Phoenix Project</a>
    <a class="item" href="/dashboard">Dashboard</a>
    <a class="item" href="/anagrafica">Anagrafica</a>
    <a class="item" href="/miei-sogni">I miei sogni</a>
    <a class="item" href="/dteam">D-Team</a>
    <a class="item" href="/tutor">Tutor</a>
    <a class="item" href="/movimenti">Movimenti</a>
    <a class="item" href="/chat">Chat</a>
    <a class="item" href="/logout">Esci</a>
</div>


<!-- Page -->
<div id="page" class="pusher">
  {block name="page_superheader"}{/block}
    
  {block name="page_header"}
  <div id="page_header" class="ui">
      {block name="header"}
      <div class="ui inverted vertical masthead center aligned segment">
        <div class="ui container">
          <div class="ui large secondary inverted pointing menu">
            <a class="toc item">
              <i class="sidebar icon"></i>
            </a>
            <a class="logo" href="/"><img src="/static/images/fenice.png" height="50" class="image" title="Home Phoenix Project"></a>
            <a class="{if $REQUEST_URI == '/'}active{/if} item" href="/">Home</a>
            <a class="{if $REQUEST_URI == '/dashboard'}active{/if} item" href="/dashboard">Dashboard</a>
            <a class="{if $REQUEST_URI == '/anagrafica'}active{/if} item" href="/anagrafica">Anagrafica</a>
            <a class="{if $REQUEST_URI == '/miei-sogni'}active{/if} item" href="/miei-sogni">I miei sogni</a>
            <a class="{if $REQUEST_URI == '/dteam'}active{/if} item" href="/dteam">D-Team</a>
            <a class="{if $REQUEST_URI == '/tutor'}active{/if} item" href="/tutor">Tutor</a>
            <a class="{if $REQUEST_URI == '/movimenti'}active{/if} item" href="/movimenti">Movimenti</a>
            <a class="{if $REQUEST_URI == '/chat'}active{/if} item" href="/chat">Chat</a>
            <a class="item" href="/logout">Esci</a>
          </div>
        </div>

        {block name="home_header"}
        {/block}
      </div>
      {/block}
  </div>
  {/block}
  
  <!-- Page Contents -->
  {block name="page_content"}
  <div id="page_content" class="ui">
      <div class="ui container" style="">
      {block name="content"}
      {/block}
      </div>
  </div>
  {/block}
  
  <!-- Page Footer -->
  {block name="page_footer"}
  {/block}
</div>
{/block}
